/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BulkItemRequest
implements Streamable {
    private int id;
    private DocWriteRequest request;
    private volatile BulkItemResponse primaryResponse;

    BulkItemRequest() {
    }

    public BulkItemRequest(int id, DocWriteRequest request) {
        assert (request instanceof IndicesRequest);
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public DocWriteRequest request() {
        return this.request;
    }

    public String index() {
        assert (this.request.indices().length == 1);
        return this.request.indices()[0];
    }

    BulkItemResponse getPrimaryResponse() {
        return this.primaryResponse;
    }

    void setPrimaryResponse(BulkItemResponse primaryResponse) {
        this.primaryResponse = primaryResponse;
    }

    boolean isIgnoreOnReplica() {
        return this.primaryResponse != null && (this.primaryResponse.isFailed() || ((DocWriteResponse)this.primaryResponse.getResponse()).getResult() == DocWriteResponse.Result.NOOP);
    }

    public void abort(String index, Exception cause) {
        if (this.primaryResponse == null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(index, this.request.type(), this.request.id(), Objects.requireNonNull(cause), true);
            this.setPrimaryResponse(new BulkItemResponse(this.id, this.request.opType(), failure));
        } else {
            assert (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) : "response [" + Strings.toString(this.primaryResponse) + "]; cause [" + cause + "]";
            if (this.primaryResponse.isFailed() && this.primaryResponse.getFailure().isAborted()) {
                this.primaryResponse.getFailure().getCause().addSuppressed(cause);
            } else {
                throw new IllegalStateException("aborting item that with response [" + this.primaryResponse + "] that was previously processed", cause);
            }
        }
    }

    public static BulkItemRequest readBulkItem(StreamInput in) throws IOException {
        BulkItemRequest item = new BulkItemRequest();
        item.readFrom(in);
        return item;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.request = DocWriteRequest.readDocumentRequest(in);
        if (in.readBoolean()) {
            this.primaryResponse = BulkItemResponse.readBulkItem(in);
            this.request.version(this.primaryResponse.getVersion());
            this.request.versionType(this.request.versionType().versionTypeForReplicationAndRecovery());
        }
        if (in.getVersion().before(Version.V_5_6_0)) {
            boolean ignoreOnReplica = in.readBoolean();
            assert (ignoreOnReplica == this.isIgnoreOnReplica()) : "ignoreOnReplica mismatch. wire [" + ignoreOnReplica + "], ours [" + this.isIgnoreOnReplica() + "]";
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        DocWriteRequest.writeDocumentRequest(out, this.request);
        out.writeOptionalStreamable(this.primaryResponse);
        if (out.getVersion().before(Version.V_5_6_0)) {
            out.writeBoolean(this.isIgnoreOnReplica());
        }
    }
}

