/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;

public final class HugeStringHashBuilder {
    private BytesRefHash hash = new BytesRefHash();
    private final BytesRefBuilder scratch = new BytesRefBuilder();

    public HugeStringHashBuilder add(String str) {
        Objects.requireNonNull(str, "str");
        if (this.hash == null) {
            throw new IllegalStateException("Cannot add additional elements once Set<String> is built.");
        }
        this.scratch.copyChars((CharSequence)str);
        this.hash.add(this.scratch.get());
        return this;
    }

    public Set<String> build() {
        if (this.hash == null) {
            throw new IllegalStateException("build() can only be called once.");
        }
        this.scratch.clear();
        try {
            SetImpl setImpl = new SetImpl(this.hash);
            return setImpl;
        }
        finally {
            this.hash = null;
        }
    }

    private static final class SetImpl
    extends AbstractSet<String> {
        private final BytesRefHash hash;
        private final BytesRefBuilder scratch = new BytesRefBuilder();

        SetImpl(BytesRefHash hash) {
            this.hash = hash;
        }

        @Override
        public Stream<String> stream() {
            return IntStream.range(0, this.hash.size()).mapToObj(keyId -> this.hash.get(keyId, new BytesRef()).utf8ToString());
        }

        @Override
        public Iterator<String> iterator() {
            return this.stream().iterator();
        }

        @Override
        public Spliterator<String> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof String) {
                this.scratch.copyChars((CharSequence)((String)o));
                return this.hash.find(this.scratch.get()) >= 0;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.hash.size();
        }
    }
}

