/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.mapper.MapperService;

public class SearchHitField
implements Streamable,
Iterable<Object> {
    private String name;
    private List<Object> values;

    private SearchHitField() {
    }

    public SearchHitField(String name, List<Object> values) {
        this.name = name;
        this.values = values;
    }

    @Deprecated
    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    @Deprecated
    public <T> T value() {
        return this.getValue();
    }

    public <T> T getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return (T)this.values.get(0);
    }

    @Deprecated
    public List<Object> values() {
        return this.values;
    }

    public List<Object> getValues() {
        return this.values();
    }

    public boolean isMetadataField() {
        return MapperService.isMetadataField(this.name);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static SearchHitField readSearchHitField(StreamInput in) throws IOException {
        SearchHitField result = new SearchHitField();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        this.values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(in.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.values.size());
        for (Object value : this.values) {
            out.writeGenericValue(value);
        }
    }
}

