/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import de.pangaea.metadataportal.utils.KeyValuePairs;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLToKeyValuePairs {
    private final boolean serializeAttributes;
    private final Unmarshaller jaxbUnmarshaller;
    public static final String ATTRIBUTE_ELEMENT_PREFIX = "__AT_";
    private static final Set<String> HIDDEN_ATTR_NAMESPACES = Set.of("http://www.w3.org/2000/xmlns/", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema-instance");
    private static final Pattern PATTERN_SPECIAL_ATTRIBUTE_ELEMENT = Pattern.compile(Pattern.quote("__AT_").concat("(.*)"));

    public XMLToKeyValuePairs(boolean serializeAttributes) throws JAXBException {
        this.serializeAttributes = serializeAttributes;
        this.jaxbUnmarshaller = JAXBContext.newInstance((Class[])new Class[0]).createUnmarshaller();
    }

    public Object convertChilds(Node parentNode) throws JAXBException {
        if (parentNode == null) {
            return null;
        }
        boolean hasText = false;
        boolean hasElementsOrAttrs = false;
        NamedNodeMap atts = null;
        if (this.serializeAttributes && parentNode instanceof Element) {
            atts = ((Element)parentNode).getAttributes();
            int c = atts.getLength();
            for (int i = 0; i < c; ++i) {
                if (this.isXsiNamespaced(atts.item(i))) continue;
                hasElementsOrAttrs = true;
            }
        }
        block6: for (Node nod = parentNode.getFirstChild(); nod != null; nod = nod.getNextSibling()) {
            switch (nod.getNodeType()) {
                case 1: {
                    hasElementsOrAttrs = true;
                    continue block6;
                }
                case 2: {
                    if (!this.serializeAttributes || this.isXsiNamespaced(nod)) continue block6;
                    hasElementsOrAttrs = true;
                    continue block6;
                }
                case 3: 
                case 4: {
                    if (nod.getNodeValue().trim().isEmpty()) continue block6;
                    hasText = true;
                }
            }
        }
        if (hasElementsOrAttrs) {
            KeyValuePairs kv = new KeyValuePairs();
            if (this.serializeAttributes && atts != null) {
                int c = atts.getLength();
                for (int i = 0; i < c; ++i) {
                    this.convertNode(kv, atts.item(i));
                }
            }
            for (Node nod = parentNode.getFirstChild(); nod != null; nod = nod.getNextSibling()) {
                this.convertNode(kv, nod);
            }
            return kv.isEmpty() ? null : kv;
        }
        if (hasText) {
            JAXBElement ele = this.jaxbUnmarshaller.unmarshal(parentNode, String.class);
            return ele.getValue();
        }
        return null;
    }

    private boolean isXsiNamespaced(Node n) {
        String uri = n.getNamespaceURI();
        return uri == null ? false : HIDDEN_ATTR_NAMESPACES.contains(uri);
    }

    private void convertNode(KeyValuePairs kv, Node n) throws JAXBException {
        if (n == null) {
            return;
        }
        switch (n.getNodeType()) {
            case 1: {
                Matcher matcher;
                String name = n.getLocalName();
                if (this.serializeAttributes && (matcher = PATTERN_SPECIAL_ATTRIBUTE_ELEMENT.matcher(name)).matches()) {
                    name = "@".concat(matcher.group(1));
                }
                kv.add(name, this.convertChilds(n));
                break;
            }
            case 9: 
            case 11: {
                throw new IllegalArgumentException("Invalid node type (DOCUMENT_NODE or DOCUMENT_FRAGMENT_NODE)");
            }
            case 2: {
                if (this.isXsiNamespaced(n) || !this.serializeAttributes) break;
                kv.add("@" + n.getLocalName(), (Object)n.getNodeValue());
                break;
            }
            case 3: 
            case 4: {
                throw new IllegalArgumentException("The element contains mixed element/text content, which is not allowed for JSON");
            }
        }
    }
}

