/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlock
implements Streamable,
ToXContent {
    private int id;
    private String description;
    private EnumSet<ClusterBlockLevel> levels;
    private boolean retryable;
    private boolean disableStatePersistence = false;
    private boolean allowReleaseResources;
    private RestStatus status;

    ClusterBlock() {
    }

    public ClusterBlock(int id, String description, boolean retryable, boolean disableStatePersistence, boolean allowReleaseResources, RestStatus status, EnumSet<ClusterBlockLevel> levels) {
        this.id = id;
        this.description = description;
        this.retryable = retryable;
        this.disableStatePersistence = disableStatePersistence;
        this.status = status;
        this.levels = levels;
        this.allowReleaseResources = allowReleaseResources;
    }

    public int id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public RestStatus status() {
        return this.status;
    }

    public EnumSet<ClusterBlockLevel> levels() {
        return this.levels;
    }

    public boolean contains(ClusterBlockLevel level) {
        for (ClusterBlockLevel testLevel : this.levels) {
            if (testLevel != level) continue;
            return true;
        }
        return false;
    }

    public boolean retryable() {
        return this.retryable;
    }

    public boolean disableStatePersistence() {
        return this.disableStatePersistence;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.id));
        builder.field("description", this.description);
        builder.field("retryable", this.retryable);
        if (this.disableStatePersistence) {
            builder.field("disable_state_persistence", this.disableStatePersistence);
        }
        builder.startArray("levels");
        for (ClusterBlockLevel level : this.levels) {
            builder.value(level.name().toLowerCase(Locale.ROOT));
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ClusterBlock readClusterBlock(StreamInput in) throws IOException {
        ClusterBlock block = new ClusterBlock();
        block.readFrom(in);
        return block;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.description = in.readString();
        int len = in.readVInt();
        ArrayList<ClusterBlockLevel> levels = new ArrayList<ClusterBlockLevel>(len);
        for (int i = 0; i < len; ++i) {
            levels.add(in.readEnum(ClusterBlockLevel.class));
        }
        this.levels = EnumSet.copyOf(levels);
        this.retryable = in.readBoolean();
        this.disableStatePersistence = in.readBoolean();
        this.status = RestStatus.readFrom(in);
        this.allowReleaseResources = in.getVersion().onOrAfter(Version.V_5_5_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeString(this.description);
        out.writeVInt(this.levels.size());
        for (ClusterBlockLevel level : this.levels) {
            out.writeEnum(level);
        }
        out.writeBoolean(this.retryable);
        out.writeBoolean(this.disableStatePersistence);
        RestStatus.writeTo(out, this.status);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeBoolean(this.allowReleaseResources);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(",").append(this.description).append(", blocks ");
        String delimiter = "";
        for (ClusterBlockLevel level : this.levels) {
            sb.append(delimiter).append(level.name());
            delimiter = ",";
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterBlock that = (ClusterBlock)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isAllowReleaseResources() {
        return this.allowReleaseResources;
    }
}

