/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public final class InternalCardinality
extends InternalNumericMetricsAggregation.SingleValue
implements Cardinality {
    private final HyperLogLogPlusPlus counts;

    InternalCardinality(String name, HyperLogLogPlusPlus counts, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.counts = counts;
    }

    public InternalCardinality(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.counts = in.readBoolean() ? HyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE) : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        if (this.counts != null) {
            out.writeBoolean(true);
            this.counts.writeTo(0L, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return "cardinality";
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.counts == null ? 0L : this.counts.cardinality(0L);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        InternalCardinality reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalCardinality cardinality = (InternalCardinality)aggregation;
            if (cardinality.counts == null) continue;
            if (reduced == null) {
                reduced = new InternalCardinality(this.name, new HyperLogLogPlusPlus(cardinality.counts.precision(), BigArrays.NON_RECYCLING_INSTANCE, 1L), this.pipelineAggregators(), this.getMetaData());
            }
            reduced.merge(cardinality);
        }
        if (reduced == null) {
            return aggregations.get(0);
        }
        return reduced;
    }

    public void merge(InternalCardinality other) {
        assert (this.counts != null && other != null);
        this.counts.merge(0L, other.counts, 0L);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        long cardinality = this.getValue();
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), cardinality);
        return builder;
    }
}

