/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class LatLonDocValuesBoxQuery
extends Query {
    private final String field;
    private final int minLatitude;
    private final int maxLatitude;
    private final int minLongitude;
    private final int maxLongitude;
    private final boolean crossesDateline;

    LatLonDocValuesBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoUtils.checkLatitude((double)minLatitude);
        GeoUtils.checkLatitude((double)maxLatitude);
        GeoUtils.checkLongitude((double)minLongitude);
        GeoUtils.checkLongitude((double)maxLongitude);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.crossesDateline = minLongitude > maxLongitude;
        this.minLatitude = GeoEncodingUtils.encodeLatitudeCeil((double)minLatitude);
        this.maxLatitude = GeoEncodingUtils.encodeLatitude((double)maxLatitude);
        this.minLongitude = GeoEncodingUtils.encodeLongitudeCeil((double)minLongitude);
        this.maxLongitude = GeoEncodingUtils.encodeLongitude((double)maxLongitude);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("box(minLat=").append(GeoEncodingUtils.decodeLatitude((int)this.minLatitude));
        sb.append(", maxLat=").append(GeoEncodingUtils.decodeLatitude((int)this.maxLatitude));
        sb.append(", minLon=").append(GeoEncodingUtils.decodeLongitude((int)this.minLongitude));
        sb.append(", maxLon=").append(GeoEncodingUtils.decodeLongitude((int)this.maxLongitude));
        return sb.append(")").toString();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesBoxQuery other = (LatLonDocValuesBoxQuery)((Object)obj);
        return this.field.equals(other.field) && this.crossesDateline == other.crossesDateline && this.minLatitude == other.minLatitude && this.maxLatitude == other.maxLatitude && this.minLongitude == other.minLongitude && this.maxLongitude == other.maxLongitude;
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Boolean.hashCode(this.crossesDateline);
        h = 31 * h + Integer.hashCode(this.minLatitude);
        h = 31 * h + Integer.hashCode(this.maxLatitude);
        h = 31 * h + Integer.hashCode(this.minLongitude);
        h = 31 * h + Integer.hashCode(this.maxLongitude);
        return h;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesBoxQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(DocIdSetIterator.all((int)context.reader().maxDoc())){

                    public boolean matches() throws IOException {
                        values.setDocument(this.approximation.docID());
                        int count = values.count();
                        for (int i = 0; i < count; ++i) {
                            long value = values.valueAt(i);
                            int lat = (int)(value >>> 32);
                            if (lat < LatLonDocValuesBoxQuery.this.minLatitude || lat > LatLonDocValuesBoxQuery.this.maxLatitude) continue;
                            int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                            if (LatLonDocValuesBoxQuery.this.crossesDateline ? lon > LatLonDocValuesBoxQuery.this.maxLongitude && lon < LatLonDocValuesBoxQuery.this.minLongitude : lon < LatLonDocValuesBoxQuery.this.minLongitude || lon > LatLonDocValuesBoxQuery.this.maxLongitude) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

