/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.config;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.ExpressionConfig;
import de.pangaea.metadataportal.config.TransformerSaxRule;
import de.pangaea.metadataportal.config.VariableConfig;
import de.pangaea.metadataportal.processor.XPathResolverImpl;
import de.pangaea.metadataportal.utils.ExtendedDigester;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Templates;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class TemplateSaxRule
extends TransformerSaxRule {
    private static final String XSL_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    private static final String XSL_PREFIX = "int-tmpl-xsl";
    private static final String CNAME = "CNAME";

    TemplateSaxRule(Config config) {
        super(config);
    }

    @Override
    protected void initDocument() throws SAXException {
        if (!this.hasBody) {
            return;
        }
        this.destContentHandler.startPrefixMapping(XSL_PREFIX, XSL_NAMESPACE);
        AttributesImpl atts = new AttributesImpl();
        StringBuilder excludePrefixes = new StringBuilder("#default ").append(XSL_PREFIX);
        for (String prefix : ((ExtendedDigester)this.digester).getCurrentAssignedPrefixes()) {
            if ("".equals(prefix)) continue;
            excludePrefixes.append(' ').append(prefix);
        }
        atts.addAttribute("", "exclude-result-prefixes", "exclude-result-prefixes", CNAME, excludePrefixes.toString());
        atts.addAttribute("", "version", "version", CNAME, "1.0");
        this.destContentHandler.startElement(XSL_NAMESPACE, "stylesheet", "int-tmpl-xsl:stylesheet", atts);
        atts.clear();
        HashSet<QName> vars = new HashSet<QName>(XPathResolverImpl.BASE_VARIABLES);
        for (VariableConfig v : this.config.xPathVariables) {
            vars.add(v.name);
        }
        for (QName name : vars) {
            boolean nullNS = "".equals(name.getNamespaceURI());
            if (nullNS) {
                atts.addAttribute("", "name", "name", CNAME, name.getLocalPart());
            } else {
                this.destContentHandler.startPrefixMapping("var", name.getNamespaceURI());
                atts.addAttribute("", "name", "name", CNAME, "var:" + name.getLocalPart());
            }
            this.destContentHandler.startElement(XSL_NAMESPACE, "param", "int-tmpl-xsl:param", atts);
            atts.clear();
            this.destContentHandler.endElement(XSL_NAMESPACE, "param", "int-tmpl-xsl:param");
            if (nullNS) continue;
            this.destContentHandler.endPrefixMapping("var");
        }
        atts.addAttribute("", "match", "match", CNAME, "/");
        this.destContentHandler.startElement(XSL_NAMESPACE, "template", "int-tmpl-xsl:template", atts);
        atts.clear();
    }

    @Override
    protected void finishDocument() throws SAXException {
        if (!this.hasBody) {
            return;
        }
        this.destContentHandler.endElement(XSL_NAMESPACE, "template", "int-tmpl-xsl:template");
        this.destContentHandler.endElement(XSL_NAMESPACE, "stylesheet", "int-tmpl-xsl:stylesheet");
        this.destContentHandler.endPrefixMapping(XSL_PREFIX);
    }

    @Override
    protected void setResult(Templates t) {
        Object o = this.digester.peek();
        if (!(o instanceof ExpressionConfig)) {
            throw new RuntimeException("An XSLT template is not allowed here!");
        }
        ((ExpressionConfig)o).setTemplate(t);
    }
}

