/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.Harvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.processor.MetadataDocument;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

public final class Rebuilder
extends Harvester {
    private static final Log staticLog = LogFactory.getLog(Rebuilder.class);
    private final String sourceIndex;
    private final Harvester wrappedHarvester;
    private final int bulkSize;
    private Client client = null;

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Command line: java " + Rebuilder.class.getName() + " config.xml [elasticsearch-target-index|*]");
            return;
        }
        try {
            Config conf = new Config(args[0]);
            Rebuilder.runRebuilder(conf, args.length == 2 ? args[1] : null);
        }
        catch (Exception e) {
            staticLog.fatal((Object)"Rebuilder general error:", (Throwable)e);
        }
    }

    public static boolean runRebuilder(Config conf, String id) {
        if (Rebuilder.isAllIndexes(id) || conf.targetIndexes.containsKey(id)) {
            return Rebuilder.runHarvester(conf, id, Rebuilder.class);
        }
        throw new IllegalArgumentException("There is no targetIndex defined with id=\"" + id + "\"!");
    }

    public Rebuilder(HarvesterConfig iconfig) throws Exception {
        super(iconfig);
        this.sourceIndex = iconfig.parent.indexName;
        this.wrappedHarvester = iconfig.harvesterClass.getConstructor(HarvesterConfig.class).newInstance(iconfig);
        this.bulkSize = Integer.parseInt(iconfig.properties.getProperty("bulkSize", Integer.toString(100)));
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        this.log.info((Object)("Opening Elasticsearch index '" + this.sourceIndex + "' for rebuilding all documents of harvester '" + this.iconfig.id + "'..."));
        this.client = es.client();
        super.open(es, targetIndex);
        this.wrappedHarvester.prepareReindex(es, targetIndex);
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        try {
            this.wrappedHarvester.finishReindex(cleanShutdown);
        }
        finally {
            this.client = null;
            super.close(cleanShutdown);
        }
    }

    @Override
    public void prepareReindex(ElasticsearchConnection es, String targetIndex) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void finishReindex(boolean cleanShutdown) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public MetadataDocument createMetadataDocumentInstance() {
        return this.wrappedHarvester.createMetadataDocumentInstance();
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        props.addAll(this.wrappedHarvester.getValidHarvesterPropertyNames());
    }

    @Override
    public void harvest() throws Exception {
        if (this.client == null) {
            throw new IllegalStateException("Rebuilder was not opened!");
        }
        TimeValue time = TimeValue.timeValueMinutes((long)10L);
        SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(new String[]{this.sourceIndex}).setTypes(new String[]{this.iconfig.root.typeName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)this.iconfig.root.fieldnameSource, (String)this.iconfig.id)).setSize(this.bulkSize).setFetchSource(new String[]{this.iconfig.root.fieldnameDatestamp, this.iconfig.root.fieldnameXML}, null).addSort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).setScroll(time).get();
        do {
            for (SearchHit hit : scrollResp.getHits()) {
                MetadataDocument mdoc = this.createMetadataDocumentInstance();
                mdoc.loadFromElasticSearchHit(hit);
                if (mdoc.getXML() == null) {
                    mdoc.setDeleted(true);
                    this.log.warn((Object)("Document '" + mdoc.getIdentifier() + "' contains no XML code. It will be deleted!"));
                }
                this.addDocument(mdoc);
            }
        } while (scrollResp.getScrollId() != null && (scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(time).get()).getHits().getHits().length > 0);
        this.setHarvestingDateReference(this.fromDateReference);
    }
}

