/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.push;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.push.PushWrapperHarvester;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import io.undertow.util.PathTemplateMatch;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class PushServer {
    private static final Log log = LogFactory.getLog(PushServer.class);
    private final Config conf;
    private final Map<String, PushWrapperHarvester> harvesters = new ConcurrentHashMap<String, PushWrapperHarvester>();
    private final String host;
    private final int port;
    private final String rootPath;

    public static void main(String ... args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Command line: java " + PushServer.class.getName() + " config.xml");
            return;
        }
        try {
            Config conf = new Config(args[0]);
            new PushServer(conf, System.getProperty("server.host", "127.0.0.1"), Integer.getInteger("server.port", 8089), System.getProperty("server.rootPath")).runServer();
        }
        catch (Exception e) {
            log.fatal((Object)"PushServer general error:", (Throwable)e);
        }
    }

    public PushServer(Config conf, String host, int port, String rootPath) {
        this.conf = conf;
        this.host = host;
        this.port = port;
        this.rootPath = rootPath;
    }

    private void runServer() {
        log.info((Object)String.format(Locale.ENGLISH, "Starting panFMP push server and listening on [%s:%d]...", this.host, this.port));
        RoutingHandler handler = Handlers.routing((boolean)false).put("/{harvester}/*", this::handlePut).delete("/{harvester}/*", this::handleDelete).post("/{harvester}/_commit", this::handleCommit);
        GracefulShutdownHandler shutdownHandler = Handlers.gracefulShutdown((HttpHandler)handler);
        handler = shutdownHandler;
        if (this.rootPath != null) {
            handler = Handlers.path().addPrefixPath(this.rootPath, (HttpHandler)handler);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownHook(shutdownHandler)));
        Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)handler).build().start();
    }

    private void handlePut(HttpServerExchange e) {
        Instant lastMod;
        if (e.isInIoThread()) {
            e.dispatch(this::handlePut);
            return;
        }
        e.startBlocking();
        Map params = ((PathTemplateMatch)e.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String harvester = (String)params.get("harvester");
        String documentId = (String)params.get("*");
        String lastModHdr = e.getRequestHeaders().getFirst(Headers.LAST_MODIFIED);
        try {
            lastMod = lastModHdr == null ? null : DateUtils.parseDate((String)lastModHdr).toInstant();
        }
        catch (NullPointerException npe) {
            PushServer.sendError(e, 400, "Invalid last modified date in HTTP request: " + lastModHdr);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Index object for harvester " + harvester + ": " + documentId));
        }
        try (InputStream in = e.getInputStream();){
            InputSource saxSrc = new InputSource(in);
            saxSrc.setSystemId(documentId);
            saxSrc.setEncoding(e.getRequestCharset());
            this.getHarvester(harvester).addDocument(documentId, lastMod, (Source)new SAXSource(saxSrc));
            e.setStatusCode(202);
            e.endExchange();
        }
        catch (Exception ex) {
            PushServer.sendError(e, "Error processing " + String.valueOf(e.getRequestMethod()) + " request", ex);
        }
    }

    private void handleDelete(HttpServerExchange e) {
        Map params = ((PathTemplateMatch)e.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String harvester = (String)params.get("harvester");
        String documentId = (String)params.get("*");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Delete object for harvester " + harvester + ": " + documentId));
        }
        try {
            this.getHarvester(harvester).deleteDocument(documentId);
            e.setStatusCode(202);
            e.endExchange();
        }
        catch (Exception ex) {
            PushServer.sendError(e, "Error processing " + String.valueOf(e.getRequestMethod()) + " request", ex);
        }
    }

    private void handleCommit(HttpServerExchange e) {
        Map params = ((PathTemplateMatch)e.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String harvester = (String)params.get("harvester");
        if (PushWrapperHarvester.isValidHarvesterId(this.conf, harvester)) {
            if (this.harvesters.containsKey(harvester)) {
                log.info((Object)("Commit changes for harvester: " + harvester));
                try {
                    this.getHarvester(harvester).commitAndClose();
                    e.setStatusCode(204);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    e.setStatusCode(PushServer.getStatusCode(ex));
                }
            } else {
                log.info((Object)("Harvester not open, commit ignored: " + harvester));
                e.setStatusCode(204);
            }
        } else {
            e.setStatusCode(404);
        }
        e.endExchange();
    }

    private static void sendError(HttpServerExchange e, String message, Exception ex) {
        log.error((Object)String.format(Locale.ROOT, "[%s] %s", e.getRequestPath(), message), (Throwable)ex);
        e.setStatusCode(PushServer.getStatusCode(ex));
        if (e.isResponseChannelAvailable()) {
            e.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
            e.getResponseSender().send(String.format(Locale.ROOT, "%s: %s", message, ex), StandardCharsets.UTF_8);
        }
    }

    private static void sendError(HttpServerExchange e, int statusCode, String message) {
        log.error((Object)String.format(Locale.ROOT, "[%s] %s", e.getRequestPath(), message));
        e.setStatusCode(statusCode);
        if (e.isResponseChannelAvailable()) {
            e.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
            e.getResponseSender().send(message, StandardCharsets.UTF_8);
        }
    }

    private static int getStatusCode(Throwable e) {
        if (e instanceof IllegalArgumentException) {
            return 404;
        }
        return 500;
    }

    private void shutdownHook(GracefulShutdownHandler rootHandler) {
        log.info((Object)"Shutting down...");
        rootHandler.shutdown();
        rootHandler.addShutdownListener(this::shutdownNow);
        try {
            rootHandler.awaitShutdown();
        }
        catch (InterruptedException ie) {
            log.warn((Object)"Shutdown interrupted, state of push server unknown!", (Throwable)ie);
        }
        log.info((Object)"Shutdown of push server completed.");
    }

    private void shutdownNow(boolean shutdownSuccessful) {
        for (Map.Entry<String, PushWrapperHarvester> he : this.harvesters.entrySet()) {
            try {
                log.info((Object)("Commit changes for harvester for shutdown: " + he.getKey()));
                he.getValue().commitAndClose();
            }
            catch (Exception e) {
                log.error((Object)("Error shutting down and commiting changes for harvester: " + he.getKey()), (Throwable)e);
            }
        }
    }

    private PushWrapperHarvester getHarvester(String id) {
        return this.harvesters.computeIfAbsent(id, key -> PushWrapperHarvester.initializeWrapper(this.conf, key, h -> this.harvesters.remove(id)));
    }
}

