/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalMappedSignificantTerms<A extends InternalMappedSignificantTerms<A, B>, B extends InternalSignificantTerms.Bucket<B>>
extends InternalSignificantTerms<A, B> {
    protected final DocValueFormat format;
    protected final long subsetSize;
    protected final long supersetSize;
    protected final SignificanceHeuristic significanceHeuristic;
    protected final List<B> buckets;
    protected Map<String, B> bucketMap;

    protected InternalMappedSignificantTerms(String name, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<B> buckets) {
        super(name, requiredSize, minDocCount, pipelineAggregators, metaData);
        this.format = format;
        this.buckets = buckets;
        this.subsetSize = subsetSize;
        this.supersetSize = supersetSize;
        this.significanceHeuristic = significanceHeuristic;
    }

    protected InternalMappedSignificantTerms(StreamInput in, InternalSignificantTerms.Bucket.Reader<B> bucketReader) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        this.significanceHeuristic = in.readNamedWriteable(SignificanceHeuristic.class);
        this.buckets = in.readList(stream -> bucketReader.read(stream, this.subsetSize, this.supersetSize, this.format));
    }

    @Override
    protected final void writeTermTypeInfoTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        out.writeNamedWriteable(this.significanceHeuristic);
        out.writeList(this.buckets);
    }

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        return this.buckets.stream().map(bucket -> bucket).collect(Collectors.toList()).iterator();
    }

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    public B getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return (B)((InternalSignificantTerms.Bucket)this.bucketMap.get(term));
    }

    @Override
    protected long getSubsetSize() {
        return this.subsetSize;
    }

    @Override
    protected long getSupersetSize() {
        return this.supersetSize;
    }

    @Override
    protected SignificanceHeuristic getSignificanceHeuristic() {
        return this.significanceHeuristic;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.subsetSize);
        builder.field("bg_count", this.supersetSize);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            if (bucket.subsetDf < this.minDocCount) continue;
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

