/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ScrollableHitSource {
    private final AtomicReference<String> scrollId = new AtomicReference();
    protected final Logger logger;
    protected final BackoffPolicy backoffPolicy;
    protected final ThreadPool threadPool;
    protected final Runnable countSearchRetry;
    protected final Consumer<Exception> fail;

    public ScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<Exception> fail) {
        this.logger = logger;
        this.backoffPolicy = backoffPolicy;
        this.threadPool = threadPool;
        this.countSearchRetry = countSearchRetry;
        this.fail = fail;
    }

    public final void start(Consumer<Response> onResponse) {
        this.doStart(response -> {
            this.setScroll(response.getScrollId());
            this.logger.debug("scroll returned [{}] documents with a scroll id of [{}]", (Object)response.getHits().size(), (Object)response.getScrollId());
            onResponse.accept((Response)response);
        });
    }

    protected abstract void doStart(Consumer<? super Response> var1);

    public final void startNextScroll(TimeValue extraKeepAlive, Consumer<Response> onResponse) {
        this.doStartNextScroll(this.scrollId.get(), extraKeepAlive, response -> {
            this.setScroll(response.getScrollId());
            onResponse.accept((Response)response);
        });
    }

    protected abstract void doStartNextScroll(String var1, TimeValue var2, Consumer<? super Response> var3);

    public final void close(Runnable onCompletion) {
        String scrollId = this.scrollId.get();
        if (Strings.hasLength(scrollId)) {
            this.clearScroll(scrollId, () -> this.cleanup(onCompletion));
        } else {
            this.cleanup(onCompletion);
        }
    }

    protected abstract void clearScroll(String var1, Runnable var2);

    protected abstract void cleanup(Runnable var1);

    public final void setScroll(String scrollId) {
        this.scrollId.set(scrollId);
    }

    public static class SearchFailure
    implements Writeable,
    ToXContent {
        private final Throwable reason;
        @Nullable
        private final String index;
        @Nullable
        private final Integer shardId;
        @Nullable
        private final String nodeId;

        public SearchFailure(Throwable reason, @Nullable String index, @Nullable Integer shardId, @Nullable String nodeId) {
            this.index = index;
            this.shardId = shardId;
            this.reason = Objects.requireNonNull(reason, "reason cannot be null");
            this.nodeId = nodeId;
        }

        public SearchFailure(Throwable reason) {
            this(reason, null, null, null);
        }

        public SearchFailure(StreamInput in) throws IOException {
            this.reason = in.readException();
            this.index = in.readOptionalString();
            this.shardId = in.readOptionalVInt();
            this.nodeId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeException(this.reason);
            out.writeOptionalString(this.index);
            out.writeOptionalVInt(this.shardId);
            out.writeOptionalString(this.nodeId);
        }

        public String getIndex() {
            return this.index;
        }

        public Integer getShardId() {
            return this.shardId;
        }

        public Throwable getReason() {
            return this.reason;
        }

        @Nullable
        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field("index", this.index);
            }
            if (this.shardId != null) {
                builder.field("shard", this.shardId);
            }
            if (this.nodeId != null) {
                builder.field("node", this.nodeId);
            }
            builder.field("reason");
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString(this);
        }
    }

    public static class BasicHit
    implements Hit {
        private final String index;
        private final String type;
        private final String id;
        private final long version;
        private BytesReference source;
        private XContentType xContentType;
        private String parent;
        private String routing;
        private Long timestamp;
        private Long ttl;

        public BasicHit(String index, String type, String id, long version) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.version = version;
        }

        @Override
        public String getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public BytesReference getSource() {
            return this.source;
        }

        @Override
        public XContentType getXContentType() {
            return this.xContentType;
        }

        public BasicHit setSource(BytesReference source, XContentType xContentType) {
            this.source = source;
            this.xContentType = xContentType;
            return this;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        public BasicHit setParent(String parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public String getRouting() {
            return this.routing;
        }

        public BasicHit setRouting(String routing) {
            this.routing = routing;
            return this;
        }

        @Override
        public Long getTimestamp() {
            return this.timestamp;
        }

        public BasicHit setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Long getTTL() {
            return this.ttl;
        }

        public BasicHit setTTL(Long ttl) {
            this.ttl = ttl;
            return this;
        }
    }

    public static interface Hit {
        public String getIndex();

        public String getType();

        public String getId();

        public long getVersion();

        @Nullable
        public BytesReference getSource();

        @Nullable
        public XContentType getXContentType();

        @Nullable
        public String getParent();

        @Nullable
        public String getRouting();

        @Nullable
        public Long getTimestamp();

        @Nullable
        public Long getTTL();
    }

    public static class Response {
        private final boolean timedOut;
        private final List<SearchFailure> failures;
        private final long totalHits;
        private final List<? extends Hit> hits;
        private final String scrollId;

        public Response(boolean timedOut, List<SearchFailure> failures, long totalHits, List<? extends Hit> hits, String scrollId) {
            this.timedOut = timedOut;
            this.failures = failures;
            this.totalHits = totalHits;
            this.hits = hits;
            this.scrollId = scrollId;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public final List<SearchFailure> getFailures() {
            return this.failures;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public List<? extends Hit> getHits() {
            return this.hits;
        }

        public String getScrollId() {
            return this.scrollId;
        }
    }
}

