/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.processor;

import de.pangaea.metadataportal.config.ExpressionConfig;
import de.pangaea.metadataportal.config.FieldConfig;
import de.pangaea.metadataportal.config.FilterConfig;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.config.VariableConfig;
import de.pangaea.metadataportal.processor.XPathResolverImpl;
import de.pangaea.metadataportal.utils.BooleanParser;
import de.pangaea.metadataportal.utils.ISODateFormatter;
import de.pangaea.metadataportal.utils.KeyValuePairs;
import de.pangaea.metadataportal.utils.LenientDateParser;
import de.pangaea.metadataportal.utils.LoggingErrorListener;
import de.pangaea.metadataportal.utils.StaticFactories;
import de.pangaea.metadataportal.utils.XMLToKeyValuePairs;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.search.SearchHit;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetadataDocument {
    static final Log log = LogFactory.getLog(MetadataDocument.class);
    protected boolean deleted = false;
    protected Instant datestamp = null;
    protected String identifier = null;
    protected final HarvesterConfig iconfig;
    private Document dom = null;
    private String xmlCache = null;
    private XMLConverter converter = null;

    public MetadataDocument(HarvesterConfig iconfig) {
        this.iconfig = iconfig;
    }

    public void loadFromElasticSearchHit(SearchHit hit) throws Exception {
        String xml;
        this.deleted = false;
        this.datestamp = null;
        Map fields = hit.getSourceAsMap();
        this.identifier = hit.getId();
        String datestampStr = (String)fields.get(this.iconfig.root.fieldnameDatestamp);
        if (datestampStr != null) {
            try {
                this.datestamp = Instant.parse(datestampStr);
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)("Datestamp of document '" + this.identifier + "' is invalid: " + iae.getMessage() + " - Deleting datestamp."));
                this.datestamp = null;
            }
        }
        if ((xml = (String)fields.get(this.iconfig.root.fieldnameXML)) == null) {
            this.setFinalDOM(null);
        } else {
            Document dom = StaticFactories.dombuilder.newDocument();
            StreamSource s = new StreamSource(new StringReader(xml), this.identifier);
            DOMResult r = new DOMResult((Node)dom, this.identifier);
            Transformer trans = StaticFactories.transFactory.newTransformer();
            trans.setErrorListener(new LoggingErrorListener(log));
            trans.transform(s, r);
            this.setFinalDOM(dom);
        }
    }

    public String getXML() throws Exception {
        if (this.deleted || this.dom == null) {
            return null;
        }
        if (this.xmlCache != null) {
            return this.xmlCache;
        }
        StringWriter xmlWriter = new StringWriter();
        Transformer trans = StaticFactories.transFactory.newTransformer();
        trans.setErrorListener(new LoggingErrorListener(log));
        trans.setOutputProperty("indent", "no");
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("encoding", StandardCharsets.UTF_16.name());
        DOMSource in = new DOMSource(this.dom, this.identifier);
        StreamResult out = new StreamResult(xmlWriter);
        trans.transform(in, out);
        xmlWriter.close();
        this.xmlCache = xmlWriter.toString();
        return this.xmlCache;
    }

    public void setFinalDOM(Document dom) {
        this.dom = dom;
        this.xmlCache = null;
    }

    public Document getFinalDOM() {
        return this.dom;
    }

    public synchronized XMLConverter getConverter() {
        if (this.converter == null) {
            this.converter = new XMLConverter();
        }
        return this.converter;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDatestamp(Instant datestamp) {
        this.datestamp = datestamp;
    }

    public Instant getDatestamp() {
        return this.datestamp;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "identifier=" + this.identifier + " deleted=" + this.deleted + " datestamp=" + String.valueOf(this.datestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValuePairs getKeyValuePairs() throws Exception {
        KeyValuePairs kv = this.createEmptyKeyValuePairs();
        if (!this.deleted) {
            assert (kv != null);
            if (this.dom == null) {
                throw new NullPointerException("The DOM-Tree of document may not be 'null'!");
            }
            this.processXPathVariables();
            try {
                boolean filterAccepted = this.processFilters();
                if (!filterAccepted) {
                    log.debug((Object)("Document filtered: " + this.identifier));
                    KeyValuePairs keyValuePairs = null;
                    return keyValuePairs;
                }
                this.addFields(kv);
                this.finalizeKeyValuePairs(kv);
            }
            finally {
                XPathResolverImpl.getInstance().unsetVariables();
            }
        }
        return kv;
    }

    protected KeyValuePairs createEmptyKeyValuePairs() throws Exception {
        if (this.deleted) {
            return null;
        }
        KeyValuePairs kv = new KeyValuePairs();
        kv.add(this.iconfig.root.fieldnameSource, (Object)this.iconfig.id);
        if (this.datestamp != null) {
            kv.add(this.iconfig.root.fieldnameDatestamp, (Object)ISODateFormatter.formatElasticsearch(this.datestamp));
        }
        return kv;
    }

    protected void finalizeKeyValuePairs(KeyValuePairs kv) throws Exception {
        kv.add(this.iconfig.root.fieldnameXML, (Object)this.getXML());
    }

    protected void addFields(KeyValuePairs kv) throws Exception {
        for (FieldConfig f : this.iconfig.root.fields.values()) {
            if (f.datatype == FieldConfig.DataType.XHTML) {
                this.addField(kv, f, this.evaluateTemplateAsXHTML(f));
                continue;
            }
            boolean needDefault = f.datatype == FieldConfig.DataType.NUMBER || f.datatype == FieldConfig.DataType.INTEGER || f.datatype == FieldConfig.DataType.BOOLEAN || f.datatype == FieldConfig.DataType.DATETIME;
            Object value = null;
            if (f.xPathExpr != null) {
                try {
                    value = f.xPathExpr.evaluate(this.dom, XPathConstants.NODESET);
                }
                catch (XPathExpressionException ex) {
                    value = f.xPathExpr.evaluate(this.dom, XPathConstants.STRING);
                }
            } else if (f.xslt != null) {
                value = this.evaluateTemplate(f);
            } else {
                throw new NullPointerException("Both XPath and template are NULL for field " + f.name);
            }
            if (value instanceof NodeList) {
                NodeList nodes = (NodeList)value;
                int c = nodes.getLength();
                block11: for (int i = 0; i < c; ++i) {
                    Node nod = nodes.item(i);
                    switch (f.datatype) {
                        case XML: {
                            if (nod.getNodeType() != 1) continue block11;
                            DOMSource in = new DOMSource(nodes.item(i));
                            StringWriter xmlWriter = new StringWriter();
                            StreamResult out = new StreamResult(xmlWriter);
                            Transformer trans = StaticFactories.transFactory.newTransformer();
                            trans.setErrorListener(new LoggingErrorListener(log));
                            trans.setOutputProperty("indent", "no");
                            trans.setOutputProperty("omit-xml-declaration", "yes");
                            trans.setOutputProperty("encoding", StandardCharsets.UTF_16.name());
                            trans.transform(in, out);
                            xmlWriter.close();
                            this.addField(kv, f, xmlWriter.toString());
                            continue block11;
                        }
                        case JSON: {
                            if (nod.getNodeType() != 1) continue block11;
                            nod.normalize();
                            Object o = new XMLToKeyValuePairs(true).convertChilds(nod);
                            if (o == null) continue block11;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("AddField: " + f.name + "=" + String.valueOf(o)));
                            }
                            kv.add(f.name, o);
                            continue block11;
                        }
                        default: {
                            StringBuilder sb = new StringBuilder();
                            this.walkNodeTexts(sb, nod, true);
                            String val = sb.toString().trim();
                            if (val.isEmpty()) continue block11;
                            this.addField(kv, f, val);
                            needDefault = false;
                        }
                    }
                }
            } else if (value instanceof String) {
                switch (f.datatype) {
                    case XML: {
                        throw new UnsupportedOperationException("Fields with datatype XML may only return NODESETs on evaluation!");
                    }
                    case JSON: {
                        throw new UnsupportedOperationException("Fields with datatype JSON may only return NODESETs on evaluation!");
                    }
                }
                String s = (String)value;
                s = s.trim();
                if (!s.isEmpty()) {
                    this.addField(kv, f, s);
                    needDefault = false;
                }
            } else {
                throw new UnsupportedOperationException("Invalid Java data type of expression result: " + value.getClass().getName());
            }
            if (!needDefault || f.defaultValue == null) continue;
            this.addField(kv, f, f.defaultValue);
        }
    }

    protected boolean processFilters() throws Exception {
        boolean accept = this.iconfig.root.filterDefault == FilterConfig.FilterType.ACCEPT;
        block4: for (FilterConfig f : this.iconfig.root.filters) {
            if (f.xPathExpr == null) {
                throw new NullPointerException("Filters need to contain a XPath expression, which is NULL!");
            }
            Boolean b = (Boolean)f.xPathExpr.evaluate(this.dom, XPathConstants.BOOLEAN);
            if (b == null) {
                throw new XPathExpressionException("The filter XPath did not return a valid BOOLEAN value!");
            }
            if (b.booleanValue() && log.isTraceEnabled()) {
                log.trace((Object)("FilterMatch: " + String.valueOf(f)));
            }
            switch (f.type) {
                case ACCEPT: {
                    if (!b.booleanValue()) continue block4;
                    accept = true;
                    continue block4;
                }
                case DENY: {
                    if (!b.booleanValue()) continue block4;
                    accept = false;
                    continue block4;
                }
            }
            throw new AssertionError((Object)"Invalid filter type (should never happen!)");
        }
        return accept;
    }

    protected void addSystemVariables(Map<QName, Object> vars) {
        if (this.identifier == null || this.iconfig == null || this.iconfig.id == null) {
            throw new NullPointerException();
        }
        vars.put(XPathResolverImpl.VARIABLE_HARVESTER_ID, this.iconfig.id);
        vars.put(XPathResolverImpl.VARIABLE_DOC_IDENTIFIER, this.identifier);
        vars.put(XPathResolverImpl.VARIABLE_DOC_DATESTAMP, this.datestamp == null ? "" : this.datestamp.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processXPathVariables() throws Exception {
        boolean needCleanup = true;
        Map<QName, Object> data = XPathResolverImpl.getInstance().initVariables();
        try {
            this.addSystemVariables(data);
            for (VariableConfig f : this.iconfig.root.xPathVariables) {
                Object value = null;
                if (f.xPathExpr != null) {
                    try {
                        value = f.xPathExpr.evaluate(this.dom, XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException ex) {
                        value = f.xPathExpr.evaluate(this.dom, XPathConstants.STRING);
                    }
                } else if (f.xslt != null) {
                    value = this.evaluateTemplate(f);
                } else {
                    throw new NullPointerException("Both XPath and template are NULL for variable " + String.valueOf(f.name));
                }
                if (value == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Variable: " + String.valueOf(f.name) + "=" + String.valueOf(value)));
                }
                data.put(f.name, value);
            }
            needCleanup = false;
        }
        finally {
            if (needCleanup) {
                XPathResolverImpl.getInstance().unsetVariables();
            }
        }
    }

    protected NodeList evaluateTemplate(ExpressionConfig expr) throws TransformerException {
        Transformer trans = expr.xslt.newTransformer();
        trans.setErrorListener(new LoggingErrorListener(log));
        Map<QName, Object> vars = XPathResolverImpl.getInstance().getCurrentVariableMap();
        for (Map.Entry<QName, Object> entry : vars.entrySet()) {
            trans.setParameter(entry.getKey().toString(), entry.getValue());
        }
        DocumentFragment df = this.dom.createDocumentFragment();
        trans.transform(new DOMSource(this.dom, this.identifier), new DOMResult(df));
        return df.getChildNodes();
    }

    protected String evaluateTemplateAsXHTML(FieldConfig expr) throws TransformerException, IOException {
        if (expr.datatype != FieldConfig.DataType.XHTML) {
            throw new IllegalArgumentException("Datatype must be XHTML for evaluateTemplateAsXHTML()");
        }
        Transformer trans = expr.xslt.newTransformer();
        trans.setErrorListener(new LoggingErrorListener(log));
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("doctype-public", "-//W3C//DTD XHTML 1.0 Transitional//EN");
        trans.setOutputProperty("indent", "no");
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("encoding", StandardCharsets.UTF_16.name());
        Map<QName, Object> vars = XPathResolverImpl.getInstance().getCurrentVariableMap();
        for (Map.Entry<QName, Object> entry : vars.entrySet()) {
            trans.setParameter(entry.getKey().toString(), entry.getValue());
        }
        StringWriter xmlWriter = new StringWriter();
        StreamResult out = new StreamResult(xmlWriter);
        trans.transform(new DOMSource(this.dom, this.identifier), out);
        xmlWriter.close();
        return xmlWriter.toString();
    }

    protected void walkNodeTexts(StringBuilder sb, Node n, boolean topLevel) {
        if (n == null) {
            return;
        }
        switch (n.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                for (Node nod = n.getFirstChild(); nod != null; nod = nod.getNextSibling()) {
                    this.walkNodeTexts(sb, nod, false);
                    sb.append('\n');
                }
                break;
            }
            case 2: {
                if (!topLevel) break;
            }
            case 3: 
            case 4: {
                sb.append(n.getNodeValue());
            }
        }
    }

    protected void addField(KeyValuePairs kv, FieldConfig f, String val) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("AddField: " + f.name + "=" + val));
        }
        switch (f.datatype) {
            case DATETIME: {
                kv.add(f.name, (Object)LenientDateParser.parseDate(val));
                break;
            }
            case NUMBER: {
                kv.add(f.name, (Object)Double.parseDouble(val));
                break;
            }
            case INTEGER: {
                kv.add(f.name, (Object)Long.parseLong(val));
                break;
            }
            case BOOLEAN: {
                kv.add(f.name, (Object)BooleanParser.parseBoolean(val));
                break;
            }
            case XML: 
            case STRING: 
            case XHTML: {
                kv.add(f.name, (Object)val);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid field datatype for addField(): " + String.valueOf((Object)f.datatype)));
            }
        }
    }

    public class XMLConverter {
        private final boolean validate;
        private DOMResult dr = null;

        XMLConverter() {
            String v = MetadataDocument.this.iconfig.properties.getProperty("validate");
            if (MetadataDocument.this.iconfig.root.schema == null) {
                if (v != null) {
                    throw new IllegalStateException("The <validate> harvester property is only allowed if a XML schema is set in the metadata properties!");
                }
                this.validate = false;
            } else {
                this.validate = v == null ? true : BooleanParser.parseBoolean(v);
            }
        }

        private DOMResult validate(final DOMSource ds, final boolean wasTransformed) throws SAXException, IOException {
            if (!this.validate) {
                return this.DOMSource2Result(ds);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating '" + ds.getSystemId() + "'..."));
            }
            Validator val = MetadataDocument.this.iconfig.root.schema.newValidator();
            val.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    log.warn((Object)("Validation warning in " + (wasTransformed ? "XSL transformed " : "") + "document '" + ds.getSystemId() + "': " + e.getMessage()));
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    String msg = "Validation error in " + (wasTransformed ? "XSL transformed " : "") + "document '" + ds.getSystemId() + "': " + e.getMessage();
                    if (MetadataDocument.this.iconfig.root.haltOnSchemaError) {
                        throw new SAXException(msg);
                    }
                    log.error((Object)msg);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException("Fatal validation error in " + (wasTransformed ? "XSL transformed " : "") + "document '" + ds.getSystemId() + "': " + e.getMessage());
                }
            });
            DOMResult dr = MetadataDocument.this.iconfig.root.validateWithAugmentation ? this.emptyDOMResult(ds.getSystemId()) : null;
            val.validate(ds, dr);
            return dr == null ? this.DOMSource2Result(ds) : dr;
        }

        private void setTransformerProperties(final Transformer trans) throws TransformerException {
            trans.setErrorListener(new LoggingErrorListener(log));
            AbstractMap<QName, Object> paramMap = new AbstractMap<QName, Object>(){

                @Override
                public Set<Map.Entry<QName, Object>> entrySet() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object put(QName key, Object value) {
                    trans.setParameter(key.toString(), value);
                    return null;
                }
            };
            MetadataDocument.this.addSystemVariables((Map<QName, Object>)paramMap);
            paramMap.putAll(MetadataDocument.this.iconfig.xsltParams);
        }

        private final DOMSource DOMResult2Source(DOMResult dr) {
            return new DOMSource(dr.getNode(), dr.getSystemId());
        }

        private final DOMResult DOMSource2Result(DOMSource ds) {
            return new DOMResult(ds.getNode(), ds.getSystemId());
        }

        private final DOMResult emptyDOMResult(String systemId) {
            return new DOMResult((Node)StaticFactories.dombuilder.newDocument(), systemId);
        }

        public void transform(Source s) throws TransformerException, SAXException, IOException {
            DOMResult dr;
            if (MetadataDocument.this.iconfig.xslt == null && s instanceof DOMSource) {
                dr = this.DOMSource2Result((DOMSource)s);
                dr.setSystemId(MetadataDocument.this.identifier);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("XSL-Transforming '" + s.getSystemId() + "' to '" + MetadataDocument.this.identifier + "'..."));
                }
                Transformer trans = MetadataDocument.this.iconfig.xslt == null ? StaticFactories.transFactory.newTransformer() : MetadataDocument.this.iconfig.xslt.newTransformer();
                this.setTransformerProperties(trans);
                dr = this.emptyDOMResult(MetadataDocument.this.identifier);
                trans.transform(s, dr);
            }
            Document dom = (Document)this.validate(this.DOMResult2Source(dr), MetadataDocument.this.iconfig.xslt != null).getNode();
            dom.normalize();
            MetadataDocument.this.setFinalDOM(dom);
        }

        public ContentHandler getTransformContentHandler() throws TransformerException {
            if (this.dr != null) {
                throw new IllegalStateException("XMLConverter is currently convertig a SAX document, you cannot get a new ContentHandler!");
            }
            if (MetadataDocument.this.iconfig.xslt != null && log.isDebugEnabled()) {
                log.debug((Object)("XSL-Transforming '" + MetadataDocument.this.identifier + "'..."));
            }
            TransformerHandler handler = MetadataDocument.this.iconfig.xslt == null ? StaticFactories.transFactory.newTransformerHandler() : StaticFactories.transFactory.newTransformerHandler(MetadataDocument.this.iconfig.xslt);
            this.setTransformerProperties(handler.getTransformer());
            this.dr = this.emptyDOMResult(MetadataDocument.this.identifier);
            handler.setResult(this.dr);
            return handler;
        }

        public void finishTransformation() throws TransformerException, SAXException, IOException {
            if (this.dr == null) {
                throw new IllegalStateException("XMLConverter is not convertig a SAX document, you cannot get a result DOM tree!");
            }
            Document dom = (Document)this.validate(this.DOMResult2Source(this.dr), MetadataDocument.this.iconfig.xslt != null).getNode();
            dom.normalize();
            this.dr = null;
            MetadataDocument.this.setFinalDOM(dom);
        }
    }
}

