/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.TargetIndexConfig;
import de.pangaea.metadataportal.harvester.Harvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UpdateAliases {
    private static final Log staticLog = LogFactory.getLog(UpdateAliases.class);

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Command line: java " + UpdateAliases.class.getName() + " config.xml [elasticsearch-target-index|*]");
            return;
        }
        try {
            Config conf = new Config(args[0]);
            UpdateAliases.runUpdateAliases(conf, args.length == 2 ? args[1] : null);
        }
        catch (Exception e) {
            staticLog.fatal((Object)"Update alias tool general error:", (Throwable)e);
        }
    }

    public static void runUpdateAliases(Config conf, String id) throws IOException {
        Collection<TargetIndexConfig> subset;
        if (Harvester.isAllIndexes(id)) {
            subset = conf.targetIndexes.values();
        } else {
            if (!conf.targetIndexes.containsKey(id)) {
                throw new IllegalArgumentException("There is no targetIndex defined with id=\"" + id + "\"!");
            }
            subset = Collections.singletonList(conf.targetIndexes.get(id));
        }
        try (ElasticsearchConnection es = new ElasticsearchConnection(conf);){
            for (TargetIndexConfig ticonf : subset) {
                es.updateAliases(ticonf);
            }
        }
    }
}

