/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.SingleFileEntitiesHarvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.processor.MinimalTransportClient;
import de.pangaea.metadataportal.utils.HostAndPort;
import java.io.StringReader;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

public class ElasticsearchHarvester
extends SingleFileEntitiesHarvester {
    private final String identifierPrefix;
    private final String xmlField;
    private final String datestampField;
    private final String[] sourceIndexes;
    private final String[] types;
    private final QueryBuilder query;
    private final String queryInfo;
    private final int bulkSize;
    private boolean closeClient = false;
    private Client client = null;

    public ElasticsearchHarvester(HarvesterConfig iconfig) {
        super(iconfig);
        boolean hasJsonQuery;
        this.bulkSize = Integer.parseInt(iconfig.properties.getProperty("bulkSize", Integer.toString(100)));
        this.identifierPrefix = iconfig.properties.getProperty("identifierPrefix", "");
        this.datestampField = iconfig.properties.getProperty("datestampField", iconfig.root.fieldnameDatestamp);
        this.xmlField = iconfig.properties.getProperty("xmlField", iconfig.root.fieldnameXML);
        String v = iconfig.properties.getProperty("indexes");
        if (v == null || v.isEmpty()) {
            throw new IllegalArgumentException("Missing harvester property 'indexes'.");
        }
        this.sourceIndexes = v.split("\\s*,\\s*");
        this.types = iconfig.properties.getProperty("types", iconfig.root.typeName).split("\\s*,\\s*");
        String qstr = iconfig.properties.getProperty("queryString");
        String jsonQuery = iconfig.properties.getProperty("jsonQuery");
        boolean hasQstr = qstr != null && !qstr.isEmpty();
        boolean bl = hasJsonQuery = jsonQuery != null && !jsonQuery.isEmpty();
        if (hasQstr && hasJsonQuery) {
            throw new IllegalArgumentException("Cannot give both 'queryString' and 'jsonQuery' harvester property.");
        }
        if (hasQstr) {
            this.queryInfo = "documents matching query [" + qstr + "]";
            this.query = QueryBuilders.queryStringQuery((String)qstr);
        } else if (hasJsonQuery) {
            this.queryInfo = "documents matching JSON query";
            this.query = QueryBuilders.wrapperQuery((String)jsonQuery);
        } else {
            assert (!hasJsonQuery && !hasQstr);
            this.queryInfo = "all documents";
            this.query = QueryBuilders.matchAllQuery();
        }
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        String esAddress = this.iconfig.properties.getProperty("elasticsearchAddress");
        if (esAddress != null && !esAddress.isEmpty()) {
            Settings settings = this.iconfig.root.esSettings == null ? Settings.Builder.EMPTY_SETTINGS : this.iconfig.root.esSettings;
            InetSocketTransportAddress addr = new InetSocketTransportAddress(HostAndPort.parse(esAddress, 9300));
            this.log.info((Object)("Connecting to external Elasticsearch node " + String.valueOf(addr) + " for harvesting " + this.queryInfo + "..."));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ES connection settings: " + String.valueOf(settings.getAsMap())));
            }
            this.client = new MinimalTransportClient(settings, new Class[0]).addTransportAddress((TransportAddress)addr);
            this.closeClient = true;
        } else {
            this.log.info((Object)("Connecting to global Elasticsearch node for harvesting " + this.queryInfo + "..."));
            this.closeClient = false;
            this.client = es.client();
        }
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        try {
            if (this.closeClient && this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
            this.closeClient = false;
            super.close(cleanShutdown);
        }
    }

    @Override
    public void harvest() throws Exception {
        if (this.client == null) {
            throw new IllegalStateException("Harvester was not opened!");
        }
        TimeValue time = TimeValue.timeValueMinutes((long)10L);
        SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(this.sourceIndexes).setTypes(this.types).setQuery(this.query).setFetchSource(new String[]{this.datestampField, this.xmlField}, null).setSize(this.bulkSize).addSort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).setScroll(time).get();
        do {
            for (SearchHit hit : scrollResp.getHits()) {
                this.addSearchHit(hit);
            }
        } while (scrollResp.getScrollId() != null && (scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(time).get()).getHits().getHits().length > 0);
    }

    private void addSearchHit(SearchHit hit) throws Exception {
        String identifier = this.identifierPrefix + hit.getId();
        Map fields = hit.getSourceAsMap();
        Instant datestamp = null;
        String datestampStr = (String)fields.get(this.datestampField);
        if (datestampStr != null) {
            try {
                datestamp = Instant.parse(datestampStr);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn((Object)("Datestamp of document '" + identifier + "' is invalid: " + iae.getMessage() + " - Deleting datestamp."));
                datestamp = null;
            }
        }
        if (this.isDocumentOutdated(datestamp)) {
            String xml = (String)fields.get(this.xmlField);
            if (xml != null) {
                this.addDocument(identifier, datestamp, (Source)new StreamSource(new StringReader(xml), identifier));
            } else {
                this.log.warn((Object)("Document '" + identifier + "' has no XML contents, ignoring."));
            }
        } else {
            this.addDocument(identifier, datestamp, null);
        }
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.addAll(Arrays.asList("elasticsearchCluster", "datestampField", "xmlField", "indexes", "types", "identifierPrefix", "queryString", "jsonQuery"));
    }
}

