/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import de.pangaea.metadataportal.utils.ExtendedDigester;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class SaxRule
extends Rule {
    protected ContentHandler destContentHandler = null;
    protected Set<String> excludeNamespaces = Collections.emptySet();
    ContentHandler lastContentHandler = null;

    public static SaxRule emptyRule() {
        SaxRule sr = new SaxRule();
        sr.setContentHandler(new DefaultHandler());
        return sr;
    }

    public void setDigester(Digester digester) {
        if (!(digester instanceof ExtendedDigester)) {
            throw new IllegalArgumentException("You can only use this rule in a " + ExtendedDigester.class.getName() + " instance!");
        }
        super.setDigester(digester);
    }

    public void setContentHandler(ContentHandler ch) {
        this.destContentHandler = ch;
    }

    public ContentHandler getContentHandler() {
        return this.destContentHandler;
    }

    public void setExcludeNamespaces(Set<String> excludeNamespaces) {
        this.excludeNamespaces = excludeNamespaces == null ? Collections.emptySet() : excludeNamespaces;
    }

    protected void initDocument() throws SAXException {
    }

    protected void finishDocument() throws SAXException {
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.destContentHandler == null) {
            throw new IllegalStateException("You must set a target ContentHandler instance before processing this rule!");
        }
        if (this.lastContentHandler != null) {
            throw new IllegalStateException("begin(...) called twice!");
        }
        SaxFilter filter = new SaxFilter();
        filter.setDocumentLocator(this.digester.getDocumentLocator());
        this.lastContentHandler = this.digester.getCustomContentHandler();
        this.digester.setCustomContentHandler((ContentHandler)filter);
        this.destContentHandler.startDocument();
        ((ExtendedDigester)this.digester).replayStartPrefixMappings(this.destContentHandler, this.excludeNamespaces);
        this.initDocument();
    }

    public void end(String namespace, String name) throws Exception {
        this.finishDocument();
        ((ExtendedDigester)this.digester).replayEndPrefixMappings(this.destContentHandler, this.excludeNamespaces);
        this.destContentHandler.endDocument();
    }

    private final class SaxFilter
    extends XMLFilterImpl {
        private int elementCounter = 0;

        public SaxFilter() {
            this.setContentHandler(SaxRule.this.destContentHandler);
            if (SaxRule.this.destContentHandler instanceof EntityResolver) {
                this.setEntityResolver((EntityResolver)((Object)SaxRule.this.destContentHandler));
            }
            if (SaxRule.this.destContentHandler instanceof DTDHandler) {
                this.setDTDHandler((DTDHandler)((Object)SaxRule.this.destContentHandler));
            }
            if (SaxRule.this.destContentHandler instanceof ErrorHandler) {
                this.setErrorHandler((ErrorHandler)((Object)SaxRule.this.destContentHandler));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.elementCounter == 0) {
                SaxRule.this.digester.setCustomContentHandler(SaxRule.this.lastContentHandler);
                SaxRule.this.lastContentHandler = null;
                SaxRule.this.digester.endElement(namespaceURI, localName, qName);
            } else {
                super.endElement(namespaceURI, localName, qName);
                --this.elementCounter;
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.elementCounter;
            super.startElement(namespaceURI, localName, qName, atts);
        }

        @Override
        public void startDocument() throws SAXException {
            throw new SAXException("Cannot start a new XML document in middle of another document!");
        }

        @Override
        public void endDocument() throws SAXException {
            throw new SAXException("Cannot end current XML document here!");
        }
    }
}

