/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;

public final class ExplainFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.explain()) {
            return;
        }
        try {
            int topLevelDocId = hitContext.hit().docId();
            Explanation explanation = context.searcher().explain(context.query(), topLevelDocId);
            for (RescoreSearchContext rescore : context.rescore()) {
                explanation = rescore.rescorer().explain(topLevelDocId, context, rescore, explanation);
            }
            hitContext.hit().explanation(explanation);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to explain doc [" + hitContext.hit().type() + "#" + hitContext.hit().id() + "]", (Throwable)e);
        }
        finally {
            context.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }
}

