/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.config;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.utils.PublicForDigesterUse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public final class TargetIndexConfig {
    private boolean checked = false;
    public final String indexName;
    public final Config root;
    public final Properties globalHarvesterProperties = new Properties();
    public final Map<String, HarvesterConfig> harvesters = new LinkedHashMap<String, HarvesterConfig>();
    public final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private String nameSuffix1 = "_v1";
    private String nameSuffix2 = "_v2";
    public Settings indexSettings = null;

    public TargetIndexConfig(Config root, String name) {
        if (name == null) {
            throw new NullPointerException("Every target index config needs a unique id!");
        }
        this.root = root;
        this.indexName = name;
    }

    private void checkImmutable() {
        if (this.checked) {
            throw new IllegalStateException("Target index configuration cannot be changed anymore!");
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void addGlobalHarvesterProperty(String value) {
        this.checkImmutable();
        if (value != null) {
            this.globalHarvesterProperties.setProperty(this.root.dig.getCurrentElementName(), value.trim());
        }
    }

    public void addHarvester(HarvesterConfig i) {
        this.checkImmutable();
        if (!this.root.harvestersAndIndexes.add(i.id)) {
            throw new IllegalArgumentException("There is already a harvester or targetIndex with id=\"" + i.id + "\" added to configuration!");
        }
        this.harvesters.put(i.id, i);
    }

    public void addAlias(String name, String filter) throws IOException {
        this.checkImmutable();
        if (name == null) {
            throw new NullPointerException("targetIndex alias name cannot be null.");
        }
        if (this.indexName.equals(name = name.trim()) || this.aliases.containsKey(name)) {
            throw new IllegalArgumentException("targetIndex alias name already exists.");
        }
        if (filter != null && filter.trim().isEmpty()) {
            filter = null;
        }
        if (filter != null) {
            XContentParser parser = XContentFactory.xContent((CharSequence)filter).createParser(NamedXContentRegistry.EMPTY, filter);
            while (parser.nextToken() != null) {
            }
        }
        this.aliases.put(name, filter);
    }

    @PublicForDigesterUse
    @Deprecated
    public void setIndexSettings(Settings.Builder bld) {
        this.checkImmutable();
        if (this.indexSettings != null) {
            throw new IllegalArgumentException("Duplicate <settings/> element");
        }
        this.indexSettings = bld.build();
    }

    public void setNameSuffix1(String nameSuffix1) {
        this.checkImmutable();
        this.nameSuffix1 = nameSuffix1;
    }

    public void setNameSuffix2(String nameSuffix2) {
        this.checkImmutable();
        this.nameSuffix2 = nameSuffix2;
    }

    public void check() throws Exception {
        for (HarvesterConfig iconf : this.harvesters.values()) {
            iconf.check();
        }
        this.checked = true;
    }

    public String getRawIndexName(boolean alternate) {
        return this.indexName + (alternate ? this.nameSuffix2 : this.nameSuffix1);
    }
}

