/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.Package;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.RetryAfterIOException;
import de.pangaea.metadataportal.harvester.SingleFileEntitiesHarvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.utils.BooleanParser;
import de.pangaea.metadataportal.utils.NoCloseInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ZipFileHarvester
extends SingleFileEntitiesHarvester {
    private String zipFile = null;
    private final Pattern filenameFilter;
    private final String identifierPrefix;
    private final boolean useZipFileDate;
    public static final int DEFAULT_RETRY_TIME = 60;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_TIMEOUT = 180;
    public static final String USER_AGENT = "Java/" + Runtime.version() + " (" + Package.getProductName() + '/' + Package.getVersion() + "; ZipFileHarvester)";
    protected final int retryCount;
    protected final int retryTime;
    protected final int timeout;

    public ZipFileHarvester(HarvesterConfig iconfig) {
        super(iconfig);
        this.identifierPrefix = iconfig.properties.getProperty("identifierPrefix", "");
        String s = iconfig.properties.getProperty("filenameFilter");
        this.filenameFilter = s == null ? null : Pattern.compile(s);
        this.retryCount = Integer.parseInt(iconfig.properties.getProperty("retryCount", Integer.toString(5)));
        this.retryTime = Integer.parseInt(iconfig.properties.getProperty("retryAfterSeconds", Integer.toString(60)));
        this.timeout = Integer.parseInt(iconfig.properties.getProperty("timeoutAfterSeconds", Integer.toString(180)));
        this.useZipFileDate = BooleanParser.parseBoolean(iconfig.properties.getProperty("useZipFileDate", "true"));
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        String zipFile = this.iconfig.properties.getProperty("zipFile");
        if (zipFile == null) {
            throw new IllegalArgumentException("Missing name / URL of ZIP file to harvest (property \"zipFile\")");
        }
        this.zipFile = this.iconfig.root.makePathAbsolute(zipFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void harvest() throws Exception {
        block22: {
            StringBuilder logstr = new StringBuilder("Opening and reading ZIP file \"").append(this.zipFile).append("\" (useZipFileDate=").append(this.useZipFileDate);
            if (this.filenameFilter != null) {
                logstr.append(", filter=\"").append(this.filenameFilter).append("\"");
            }
            logstr.append(")...");
            this.log.info((Object)logstr);
            try (InputStream is = this.openStream();){
                if (is != null) {
                    try (ZipInputStream zis = new ZipInputStream(is);){
                        ZipEntry ze = null;
                        int count = 0;
                        while ((ze = zis.getNextEntry()) != null) {
                            try {
                                ++count;
                                if (ze.isDirectory()) continue;
                                if (this.filenameFilter != null) {
                                    Matcher m;
                                    String name = ze.getName();
                                    int p = name.lastIndexOf(47);
                                    if (p >= 0) {
                                        name = name.substring(p + 1);
                                    }
                                    if (!(m = this.filenameFilter.matcher(name)).matches()) continue;
                                }
                                this.log.debug((Object)("Processing ZipEntry: " + String.valueOf(ze)));
                                this.processFile(new NoCloseInputStream(zis), ze);
                            }
                            finally {
                                zis.closeEntry();
                            }
                        }
                        if (count <= 0) {
                            throw new ZipException("The file seems to be no ZIP file, it contains no file entries.");
                        }
                        this.log.info((Object)("Finished reading contents of ZIP file '" + this.zipFile + "'."));
                        break block22;
                    }
                }
                this.cancelMissingDocumentDelete();
                this.log.info((Object)("ZIP file '" + this.zipFile + "' not modified!"));
            }
        }
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.addAll(Arrays.asList("zipFile", "identifierPrefix", "filenameFilter", "useZipFileDate", "retryCount", "retryAfterSeconds", "timeoutAfterSeconds"));
    }

    private InputStream openStream() throws IOException {
        for (int retry = 0; retry <= this.retryCount; ++retry) {
            try {
                URLConnection conn = new URL(this.zipFile).openConnection();
                conn.setConnectTimeout(this.timeout * 1000);
                conn.setReadTimeout(this.timeout * 1000);
                if (conn instanceof HttpURLConnection) {
                    conn.setRequestProperty("User-Agent", USER_AGENT);
                    conn.setRequestProperty("Accept-Encoding", "identity, *;q=0");
                    conn.setRequestProperty("Accept", "application/zip, *;q=0.1");
                    ((HttpURLConnection)conn).setInstanceFollowRedirects(true);
                    if (this.fromDateReference != null && this.useZipFileDate) {
                        conn.setIfModifiedSince(this.fromDateReference.toEpochMilli());
                    }
                }
                conn.setUseCaches(false);
                this.log.debug((Object)"Opening connection...");
                InputStream in = null;
                try {
                    conn.connect();
                    in = conn.getInputStream();
                }
                catch (IOException ioe) {
                    int after = -1;
                    int code = -1;
                    if (conn instanceof HttpURLConnection) {
                        try {
                            after = conn.getHeaderFieldInt("Retry-After", -1);
                            code = ((HttpURLConnection)conn).getResponseCode();
                        }
                        catch (IOException ioe2) {
                            after = -1;
                            code = -1;
                        }
                    }
                    if (code == 503 && after > 0) {
                        throw new RetryAfterIOException(after, ioe);
                    }
                    throw ioe;
                }
                long lastModified = conn.getLastModified();
                if (this.fromDateReference != null && this.useZipFileDate && (conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() == 304 || !this.isDocumentOutdated(lastModified == 0L ? null : Instant.ofEpochMilli(lastModified)))) {
                    this.log.debug((Object)("File not modified since " + String.valueOf(this.fromDateReference)));
                    if (in != null) {
                        in.close();
                    }
                    return null;
                }
                if (this.useZipFileDate) {
                    this.setHarvestingDateReference(lastModified == 0L ? null : Instant.ofEpochMilli(lastModified));
                }
                return in;
            }
            catch (MalformedURLException urle) {
                Path f = Paths.get(this.zipFile, new String[0]);
                Instant lastModified = Files.getLastModifiedTime(f, new LinkOption[0]).toInstant();
                if (this.useZipFileDate) {
                    this.setHarvestingDateReference(lastModified);
                }
                if (this.useZipFileDate && !this.isDocumentOutdated(lastModified)) {
                    return null;
                }
                return Files.newInputStream(f, new OpenOption[0]);
            }
            catch (NoSuchFileException nsfe) {
                throw nsfe;
            }
            catch (IOException ioe) {
                int after = this.retryTime;
                if (ioe instanceof RetryAfterIOException) {
                    RetryAfterIOException ra = (RetryAfterIOException)ioe;
                    if (retry >= this.retryCount) {
                        throw ra.getCause();
                    }
                    this.log.warn((Object)"HTTP server returned '503 Service Unavailable' with a 'Retry-After' value being set.");
                    after = ra.getRetryAfter();
                } else {
                    if (retry >= this.retryCount) {
                        throw ioe;
                    }
                    this.log.error((Object)"Server access failed with exception: ", (Throwable)ioe);
                }
                this.log.info((Object)("Retrying after " + after + " seconds (" + (this.retryCount - retry) + " retries left)..."));
                try {
                    Thread.sleep(1000L * (long)after);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException("Could not open stream.");
    }

    private void processFile(InputStream is, ZipEntry ze) throws Exception {
        String identifier = "zip:" + this.identifierPrefix + ze.getName();
        this.addDocument(identifier, this.useZipFileDate ? -1L : ze.getTime(), (Source)new StreamSource(is, identifier));
    }
}

