/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.WithDefaultsRulesWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExtendedDigester
extends Digester {
    protected final HashMap<String, LinkedList<String>> currentNamespaceMap = new HashMap();
    protected ContentHandler custContentHandler = null;

    public void setCustomContentHandler(ContentHandler c) {
        this.custContentHandler = c;
    }

    public ContentHandler getCustomContentHandler() {
        return this.custContentHandler;
    }

    public void setErrorHandler(ErrorHandler err) {
        if (err != null) {
            throw new IllegalArgumentException("You cannot set any ErrorHandler with " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void addDoNothing(String pattern) {
        this.addRule(pattern, new DoNothingRule());
    }

    public void setRulesWithInvalidElementCheck(Rules rules) {
        WithDefaultsRulesWrapper r = new WithDefaultsRulesWrapper(rules);
        r.addDefault((Rule)new InvalidElementRule());
        super.setRules((Rules)r);
    }

    public void clear() {
        this.currentNamespaceMap.clear();
        super.clear();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        LinkedList<String> stack = this.currentNamespaceMap.get(prefix);
        if (stack == null) {
            stack = new LinkedList();
            this.currentNamespaceMap.put(prefix, stack);
        }
        stack.addFirst(uri);
        if (this.custContentHandler != null) {
            this.custContentHandler.startPrefixMapping(prefix, uri);
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.endPrefixMapping(prefix);
        } else {
            super.endPrefixMapping(prefix);
        }
        LinkedList<String> stack = this.currentNamespaceMap.get(prefix);
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.currentNamespaceMap.remove(prefix);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.startElement(uri, localName, qName, atts);
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.endElement(uri, localName, qName);
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.ignorableWhitespace(ch, start, length);
        } else {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.processingInstruction(target, data);
        } else {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.custContentHandler != null) {
            this.custContentHandler.skippedEntity(name);
        } else {
            super.skippedEntity(name);
        }
    }

    public void startDocument() throws SAXException {
        this.currentNamespaceMap.clear();
        super.startDocument();
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.log.warn((Object)("SAX parse warning in \"" + ex.getSystemId() + "\", line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ": " + ex.getMessage()));
    }

    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void replayStartPrefixMappings(ContentHandler handler, Set<String> excludeNamespaces) throws SAXException {
        for (Map.Entry<String, LinkedList<String>> e : this.currentNamespaceMap.entrySet()) {
            String ns = e.getValue().getFirst();
            if (excludeNamespaces.contains(ns)) continue;
            handler.startPrefixMapping(e.getKey(), ns);
        }
    }

    public void replayEndPrefixMappings(ContentHandler handler, Set<String> excludeNamespaces) throws SAXException {
        for (Map.Entry<String, LinkedList<String>> e : this.currentNamespaceMap.entrySet()) {
            if (excludeNamespaces.contains(e.getValue().getFirst())) continue;
            handler.endPrefixMapping(e.getKey());
        }
    }

    public Set<String> getCurrentAssignedPrefixes() {
        return Collections.unmodifiableSet(this.currentNamespaceMap.keySet());
    }

    public String getCurrentNamespaceForPrefix(String prefix) {
        LinkedList<String> ns = this.currentNamespaceMap.get(prefix);
        return ns == null ? null : ns.getFirst();
    }

    public Map<String, String> getCurrentNamespaceMap() {
        HashMap<String, String> n = new HashMap<String, String>(this.currentNamespaceMap.size());
        for (Map.Entry<String, LinkedList<String>> i : this.currentNamespaceMap.entrySet()) {
            n.put(i.getKey(), i.getValue().getFirst());
        }
        return n;
    }

    public NamespaceContext getCurrentNamespaceContext(boolean strict, boolean reDefineDefaultPrefix) {
        final boolean isStrict = strict;
        final Map<String, String> prefixToNS = this.getCurrentNamespaceMap();
        prefixToNS.put("xml", "http://www.w3.org/XML/1998/namespace");
        prefixToNS.put("xmlns", "http://www.w3.org/2000/xmlns/");
        if (reDefineDefaultPrefix || !prefixToNS.containsKey("")) {
            prefixToNS.put("", "");
        }
        final HashMap<String, ArrayList<String>> nsToPrefix = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, String> e : prefixToNS.entrySet()) {
            ArrayList<String> dest = (ArrayList<String>)nsToPrefix.get(e.getValue());
            if (dest == null) {
                dest = new ArrayList<String>();
                nsToPrefix.put(e.getValue(), dest);
            }
            dest.add(e.getKey());
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Forward NamespaceContext map: " + String.valueOf(prefixToNS)));
            this.log.debug((Object)("Reverse NamespaceContext map: " + String.valueOf(nsToPrefix)));
        }
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException("Namespace prefix cannot be null");
                }
                String uri = (String)prefixToNS.get(prefix);
                if (isStrict && uri == null) {
                    throw new IllegalArgumentException("Undeclared namespace prefix: " + prefix);
                }
                return uri == null ? "" : uri;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                Iterator<String> i = this.getPrefixes(namespaceURI);
                return i.hasNext() ? i.next() : null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException("Namespace URI cannot be null");
                }
                List plist = (List)nsToPrefix.get(namespaceURI);
                return plist == null ? List.of().iterator() : Collections.unmodifiableList(plist).iterator();
            }
        };
    }

    private static final class InvalidElementRule
    extends Rule {
        InvalidElementRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            throw new SAXException("Unknown element at XML path: '" + this.digester.getMatch() + "'; tagname: '{" + namespace + "}" + name + "'");
        }
    }

    public static final class DoNothingRule
    extends Rule {
    }
}

