/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.SingleFileEntitiesHarvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.zip.DataFormatException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public class PanFMP1IndexHarvester
extends SingleFileEntitiesHarvester {
    private final String identifierPrefix;
    private final Query query;
    private final String queryInfo;
    private DirectoryReader reader = null;
    private Directory indexDir = null;
    private static final String FIELD_PREFIX = "internal-";
    public static final String FIELDNAME_CONTENT = "textcontent";
    public static final String FIELDNAME_IDENTIFIER = "internal-identifier".intern();
    public static final String FIELDNAME_DATESTAMP = "internal-datestamp".intern();
    public static final String FIELDNAME_XML = "internal-xml".intern();

    public PanFMP1IndexHarvester(HarvesterConfig iconfig) throws Exception {
        super(iconfig);
        this.identifierPrefix = iconfig.properties.getProperty("identifierPrefix", "");
        String qstr = iconfig.properties.getProperty("query");
        if (qstr == null || qstr.length() == 0) {
            this.queryInfo = "all documents";
            this.query = new MatchAllDocsQuery();
        } else {
            QueryParser.Operator defaultQueryParserOperator;
            Analyzer ana;
            this.queryInfo = "documents matching query [" + qstr + "]";
            Version luceneMatchVersion = Version.parseLeniently((String)iconfig.properties.getProperty("luceneMatchVersion", Version.LUCENE_CURRENT.toString()));
            String anaCls = iconfig.properties.getProperty("analyzerClass", StandardAnalyzer.class.getName());
            Class<Analyzer> anaClass = Class.forName(anaCls).asSubclass(Analyzer.class);
            try {
                ana = anaClass.getConstructor(Version.class).newInstance(luceneMatchVersion);
            }
            catch (NoSuchMethodException nsme1) {
                try {
                    ana = anaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    throw new IllegalArgumentException(anaClass.getName() + " does not have a public matchVersion or no-arg constructor");
                }
            }
            Class<?> c = Class.forName(iconfig.properties.getProperty("queryParserClass", QueryParser.class.getName()));
            Class<QueryParser> queryParserClass = c.asSubclass(QueryParser.class);
            Constructor<QueryParser> queryParserConstructor = queryParserClass.getConstructor(Version.class, String.class, Analyzer.class);
            String operator = iconfig.properties.getProperty("defaultQueryParserOperator", "AND").toUpperCase(Locale.ROOT);
            if ("AND".equals(operator)) {
                defaultQueryParserOperator = QueryParser.AND_OPERATOR;
            } else if ("OR".equals(operator)) {
                defaultQueryParserOperator = QueryParser.OR_OPERATOR;
            } else {
                throw new IllegalArgumentException("Search property 'defaultQueryParserOperator' is not 'AND'/'OR'");
            }
            QueryParser qp = queryParserConstructor.newInstance(luceneMatchVersion, FIELDNAME_CONTENT, ana);
            qp.setDefaultOperator(defaultQueryParserOperator);
            this.query = qp.parse(qstr);
        }
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        String d = this.iconfig.properties.getProperty("indexDir");
        if (d == null) {
            throw new IllegalArgumentException("Missing index directory path (property \"indexDir\")");
        }
        Path dir = this.iconfig.root.makePathAbsolute(d);
        this.log.info((Object)("Opening index in directory '" + String.valueOf(dir) + "' for harvesting " + this.queryInfo + "..."));
        this.indexDir = FSDirectory.open((Path)dir);
        this.reader = DirectoryReader.open((Directory)this.indexDir);
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.reader, this.indexDir});
        this.reader = null;
        this.indexDir = null;
        super.close(cleanShutdown);
    }

    @Override
    public void harvest() throws Exception {
        if (this.reader == null) {
            throw new IllegalStateException("Harvester was not opened!");
        }
        try {
            new IndexSearcher((IndexReader)this.reader).search(this.query, new Collector(){

                public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                    final LeafReader reader = context.reader();
                    return new LeafCollector(){

                        public void setScorer(Scorer scorer) throws IOException {
                        }

                        public void collect(int doc) throws IOException {
                            DocumentStoredFieldVisitor vis = new DocumentStoredFieldVisitor(new String[]{FIELDNAME_IDENTIFIER, FIELDNAME_DATESTAMP, FIELDNAME_XML});
                            reader.document(doc, (StoredFieldVisitor)vis);
                            Document ldoc = vis.getDocument();
                            try {
                                PanFMP1IndexHarvester.this.addLuceneDocument(ldoc);
                            }
                            catch (IOException ioe) {
                                throw ioe;
                            }
                            catch (Exception e) {
                                throw new RuntimeException("###collectException###", e);
                            }
                        }
                    };
                }

                public boolean needsScores() {
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            if ("###collectException###".equals(e.getMessage())) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.addAll(Arrays.asList("indexDir", "query", "luceneMatchVersion", "analyzerClass", "queryParserClass", "defaultQueryParserOperator", "identifierPrefix"));
    }

    void addLuceneDocument(Document ldoc) throws Exception {
        block9: {
            IndexableField fld;
            Object identifier = ldoc.get(FIELDNAME_IDENTIFIER);
            if (identifier == null) {
                this.log.warn((Object)"Document without identifier, ignoring.");
                return;
            }
            identifier = this.identifierPrefix + (String)identifier;
            Instant datestamp = null;
            try {
                fld = ldoc.getField(FIELDNAME_DATESTAMP);
                datestamp = Instant.ofEpochMilli(fld.numericValue().longValue());
            }
            catch (NullPointerException npe) {
                this.log.warn((Object)("Datestamp of document '" + (String)identifier + "' is invalid - Ignoring datestamp."));
                datestamp = null;
            }
            catch (NumberFormatException ne) {
                this.log.warn((Object)("Datestamp of document '" + (String)identifier + "' is invalid: " + ne.getMessage() + " - Ignoring datestamp."));
                datestamp = null;
            }
            if (this.isDocumentOutdated(datestamp)) {
                try {
                    String xml;
                    fld = ldoc.getField(FIELDNAME_XML);
                    BytesRef bytes = fld.binaryValue();
                    String string = xml = bytes != null ? CompressionTools.decompressString((BytesRef)bytes) : fld.stringValue();
                    if (xml != null) {
                        this.addDocument((String)identifier, datestamp, (Source)new StreamSource(new StringReader(xml), (String)identifier));
                        break block9;
                    }
                    this.log.warn((Object)("Document '" + (String)identifier + "' has no XML contents, ignoring."));
                }
                catch (DataFormatException de) {
                    this.log.warn((Object)("Document '" + (String)identifier + "' has invalid compressed XML contents, ignoring."));
                }
            } else {
                this.addDocument((String)identifier, datestamp, null);
            }
        }
    }
}

