/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.config;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.TargetIndexConfig;
import de.pangaea.metadataportal.harvester.Harvester;
import de.pangaea.metadataportal.utils.PublicForDigesterUse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Templates;

public final class HarvesterConfig {
    protected boolean checked = false;
    public final String id;
    public final Config root;
    public final TargetIndexConfig parent;
    public final Map<QName, Object> xsltParams = new HashMap<QName, Object>();
    public Class<? extends Harvester> harvesterClass = null;
    public final Properties properties;
    public Templates xslt = null;

    public HarvesterConfig(Config root, TargetIndexConfig parent, String id) {
        if (id == null) {
            throw new NullPointerException("Every harvester needs a unique id!");
        }
        this.root = root;
        this.parent = parent;
        this.id = id;
        this.properties = new Properties(parent.globalHarvesterProperties);
    }

    private void checkImmutable() {
        if (this.checked) {
            throw new IllegalStateException("Harvester configuration cannot be changed anymore!");
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setHarvesterClass(String v) throws ClassNotFoundException {
        this.checkImmutable();
        this.harvesterClass = Class.forName(v).asSubclass(Harvester.class);
    }

    @PublicForDigesterUse
    @Deprecated
    public void addHarvesterProperty(String value) {
        this.checkImmutable();
        if (value != null) {
            this.properties.setProperty(this.parent.root.dig.getCurrentElementName(), value.trim());
        }
    }

    public void check() throws Exception {
        Harvester h = this.harvesterClass.getConstructor(HarvesterConfig.class).newInstance(this);
        Set<String> validProperties = h.getValidHarvesterPropertyNames();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String prop = (String)en.nextElement();
            if (validProperties.contains(prop)) continue;
            throw new IllegalArgumentException("Harvester class '" + this.harvesterClass.getName() + "' for harvester '" + this.id + "' does not support property '" + prop + "'! Supported properties are: " + String.valueOf(validProperties));
        }
        this.checked = true;
    }
}

