/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.OAIHarvesterBase;
import de.pangaea.metadataportal.harvester.OAIMetadataSaxRule;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.processor.MetadataDocument;
import de.pangaea.metadataportal.utils.ExtendedDigester;
import de.pangaea.metadataportal.utils.SaxRule;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OAIStaticRepositoryHarvester
extends OAIHarvesterBase {
    private ExtendedDigester dig = null;
    String currMetadataPrefix = null;
    OAIMetadataSaxRule metadataSaxRule = null;

    public OAIStaticRepositoryHarvester(HarvesterConfig iconfig) {
        super(iconfig);
        this.filterIncomingSets = true;
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        if (this.sets != null) {
            this.log.warn((Object)"Sets are currently not supported by static OAI repositories. This may change in future (and so it is implemented in the harvester), but may only work with non-conformant repositories, that list setSpecs in metadata headers.");
        }
        this.enableMissingDocumentDelete();
    }

    @Override
    protected void recreateDigester() {
        this.dig = new ExtendedDigester();
        this.dig.setEntityResolver(this.getEntityResolver(this.dig.getEntityResolver()));
        this.dig.setNamespaceAware(true);
        this.dig.setValidating(false);
        this.dig.setXIncludeAware(false);
        this.dig.setRulesWithInvalidElementCheck((Rules)new ExtendedBaseRules());
        this.dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/static-repository");
        this.dig.addDoNothing("Repository");
        this.dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/static-repository");
        this.dig.addRule("Repository/Identify", SaxRule.emptyRule());
        this.dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/static-repository");
        this.dig.addRule("Repository/ListMetadataFormats", SaxRule.emptyRule());
        this.dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/static-repository");
        this.dig.addRule("Repository/ListRecords", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                OAIStaticRepositoryHarvester.this.currMetadataPrefix = attributes.getValue("metadataPrefix");
                if (OAIStaticRepositoryHarvester.this.currMetadataPrefix == null) {
                    throw new SAXException("Missing attribute 'metadataPrefix' at '" + this.digester.getMatch() + "'");
                }
                OAIStaticRepositoryHarvester.this.metadataSaxRule.setEnabled(OAIStaticRepositoryHarvester.this.metadataPrefix.equals(OAIStaticRepositoryHarvester.this.currMetadataPrefix));
            }

            public void end(String namespace, String name) throws Exception {
                OAIStaticRepositoryHarvester.this.currMetadataPrefix = null;
                OAIStaticRepositoryHarvester.this.metadataSaxRule.setEnabled(false);
            }
        });
        this.dig.setRuleNamespaceURI("http://www.openarchives.org/OAI/2.0/");
        this.dig.addFactoryCreate("Repository/ListRecords/record", this.getMetadataDocumentFactory());
        this.dig.addSetNext("Repository/ListRecords/record", "addDocument");
        this.dig.addCallMethod("Repository/ListRecords/record/header", "setHeaderInfo", 3);
        this.dig.addCallParam("Repository/ListRecords/record/header", 0, "status");
        this.dig.addCallParam("Repository/ListRecords/record/header/identifier", 1);
        this.dig.addCallParam("Repository/ListRecords/record/header/datestamp", 2);
        this.dig.addCallMethod("Repository/ListRecords/record/header/setSpec", "addSet", 0);
        this.metadataSaxRule = new OAIMetadataSaxRule();
        this.dig.addRule("Repository/ListRecords/record/metadata", this.metadataSaxRule);
        this.metadataSaxRule.setEnabled(false);
        this.dig.addRule("Repository/ListRecords/record/about", SaxRule.emptyRule());
    }

    @Override
    public void addDocument(MetadataDocument mdoc) throws Exception {
        if (this.metadataPrefix.equals(this.currMetadataPrefix)) {
            super.addDocument(mdoc);
        }
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        this.dig = null;
        super.close(cleanShutdown);
    }

    @Override
    public void harvest() throws Exception {
        String url = this.iconfig.properties.getProperty("url");
        if (url == null) {
            throw new NullPointerException("No URL of the OAI static repository was given!");
        }
        this.log.info((Object)("Harvesting static repository at \"" + url + "\"..."));
        AtomicReference<Instant> modifiedDate = new AtomicReference<Instant>(this.fromDateReference);
        if (this.doParse(() -> this.dig, url, modifiedDate)) {
            this.setHarvestingDateReference(modifiedDate.get());
        } else {
            this.log.info((Object)"Static OAI repository file was not modified since last harvesting, no need for re-harvesting!");
            this.cancelMissingDocumentDelete();
        }
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.add("url");
    }
}

