/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileGenerator
extends GeneratorBase {
    private static final int MIN_BUFFER_LENGTH = 770;
    protected static final byte TOKEN_BYTE_LONG_STRING_ASCII = -32;
    protected static final byte TOKEN_BYTE_INT_32 = 36;
    protected static final byte TOKEN_BYTE_INT_64 = 37;
    protected static final byte TOKEN_BYTE_BIG_INTEGER = 38;
    protected static final byte TOKEN_BYTE_FLOAT_32 = 40;
    protected static final byte TOKEN_BYTE_FLOAT_64 = 41;
    protected static final byte TOKEN_BYTE_BIG_DECIMAL = 42;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _formatFeatures;
    protected final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _bytesWritten;
    protected SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext ctxt, int jsonFeatures, int smileFeatures, ObjectCodec codec, OutputStream out) {
        super(jsonFeatures, codec);
        this._formatFeatures = smileFeatures;
        this._ioContext = ctxt;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = out;
        this._bufferRecyclable = true;
        this._outputBuffer = ctxt.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException(String.format("Internal encoding buffer length (%d) too short, must be at least %d", this._outputEnd, 770));
        }
        if (!Feature.CHECK_SHARED_NAMES.enabledIn(smileFeatures)) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if (!Feature.CHECK_SHARED_STRING_VALUES.enabledIn(smileFeatures)) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public SmileGenerator(IOContext ctxt, int jsonFeatures, int smileFeatures, ObjectCodec codec, OutputStream out, byte[] outputBuffer, int offset, boolean bufferRecyclable) {
        super(jsonFeatures, codec);
        this._formatFeatures = smileFeatures;
        this._ioContext = ctxt;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = out;
        this._bufferRecyclable = bufferRecyclable;
        this._outputTail = offset;
        this._outputBuffer = outputBuffer;
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException(String.format("Internal encoding buffer length (%d) too short, must be at least %d", this._outputEnd, 770));
        }
        if (!Feature.CHECK_SHARED_NAMES.enabledIn(smileFeatures)) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if (!Feature.CHECK_SHARED_STRING_VALUES.enabledIn(smileFeatures)) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public void writeHeader() throws IOException {
        int last = 0;
        if (Feature.CHECK_SHARED_NAMES.enabledIn(this._formatFeatures)) {
            last |= 1;
        }
        if (Feature.CHECK_SHARED_STRING_VALUES.enabledIn(this._formatFeatures)) {
            last |= 2;
        }
        if (!Feature.ENCODE_BINARY_AS_7BIT.enabledIn(this._formatFeatures)) {
            last |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)last);
    }

    protected static final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler() {
        SmileBufferRecycler<SharedStringNode> br;
        SoftReference<SmileBufferRecycler<SharedStringNode>> ref = _smileRecyclerRef.get();
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<SharedStringNode>>(br));
        }
        return br;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canWriteBinaryNatively() {
        return true;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._out;
    }

    public int getOutputBuffered() {
        return this._outputTail;
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    public final void writeFieldName(String name) throws IOException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    public SmileGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public SmileGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public SmileGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public void writeRaw(byte b) throws IOException {
        this._writeByte(b);
    }

    public void writeBytes(byte[] data, int offset, int len) throws IOException {
        this._writeBytes(data, offset, len);
    }

    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    public final void writeStartArray(int size) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._writeByte((byte)-7);
        this._writeContext = this._writeContext.getParent();
    }

    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeByte((byte)-6);
    }

    public final void writeStartObject(Object forValue) throws IOException {
        JsonWriteContext ctxt;
        this._verifyValueWrite("start an object");
        this._writeContext = ctxt = this._writeContext.createChildObjectContext();
        if (forValue != null) {
            ctxt.setCurrentValue(forValue);
        }
        this._writeByte((byte)-6);
    }

    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._writeByte((byte)-5);
    }

    public void writeArray(int[] array, int offset, int length) throws IOException {
        this._verifyOffsets(array.length, offset, length);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int ptr = this._outputTail;
        int outputEnd = this._outputEnd;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (ptr + 6 >= outputEnd) {
                this._outputTail = ptr;
                this._flushBuffer();
                ptr = this._outputTail;
            }
            ptr = this._writeNumberNoChecks(ptr, array[i]);
        }
        this._outputTail = ptr;
        this._writeByte((byte)-7);
    }

    public void writeArray(long[] array, int offset, int length) throws IOException {
        this._verifyOffsets(array.length, offset, length);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int ptr = this._outputTail;
        int outputEnd = this._outputEnd;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (ptr + 11 >= outputEnd) {
                this._outputTail = ptr;
                this._flushBuffer();
                ptr = this._outputTail;
            }
            ptr = this._writeNumberNoChecks(ptr, array[i]);
        }
        this._outputTail = ptr;
        this._writeByte((byte)-7);
    }

    public void writeArray(double[] array, int offset, int length) throws IOException {
        this._verifyOffsets(array.length, offset, length);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int ptr = this._outputTail;
        int outputEnd = this._outputEnd;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (ptr + 10 >= outputEnd) {
                this._outputTail = ptr;
                this._flushBuffer();
                ptr = this._outputTail;
            }
            ptr = this._writeNumberNoChecks(ptr, array[i]);
        }
        this._outputTail = ptr;
        this._writeByte((byte)-7);
    }

    private final void _writeFieldName(String name) throws IOException {
        int typeToken;
        int ix;
        int len = name.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (ix = this._findSeenName(name)) >= 0) {
            this._writeSharedNameReference(ix);
            return;
        }
        if (len > 64) {
            this._writeNonShortFieldName(name, len);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        int origOffset = this._outputTail++;
        int byteLen = this._shortUTF8Encode(name, 0, len);
        if (byteLen == len) {
            if (byteLen <= 64) {
                typeToken = (byte)(127 + byteLen);
            } else {
                typeToken = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (byteLen <= 56) {
            typeToken = (byte)(190 + byteLen);
        } else {
            typeToken = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[origOffset] = typeToken;
        if (this._seenNameCount >= 0) {
            this._addSeenName(name);
        }
    }

    private final void _writeNonShortFieldName(String name, int len) throws IOException {
        this._writeByte((byte)52);
        int maxLen = len + len + len;
        if (maxLen <= this._outputBuffer.length) {
            if (this._outputTail + maxLen >= this._outputEnd) {
                this._flushBuffer();
            }
            this._shortUTF8Encode(name, 0, len);
        } else {
            this._mediumUTF8Encode(name, 0, len);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(name);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString name) throws IOException {
        int ix;
        int charLen = name.charLength();
        if (charLen == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (ix = this._findSeenName(name.getValue())) >= 0) {
            this._writeSharedNameReference(ix);
            return;
        }
        byte[] bytes = name.asUnquotedUTF8();
        int byteLen = bytes.length;
        if (byteLen != charLen) {
            this._writeFieldNameUnicode(name, bytes);
            return;
        }
        if (byteLen <= 64) {
            if (this._outputTail + byteLen >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(127 + byteLen);
            System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._writeLongAsciiFieldName(bytes);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(name.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] bytes) throws IOException {
        int byteLen = bytes.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + byteLen + 1 < this._outputEnd) {
            System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._flushBuffer();
            if (byteLen < 770) {
                System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
                this._outputTail += byteLen;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(bytes, 0, byteLen);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString name, byte[] bytes) throws IOException {
        int byteLen = bytes.length;
        if (byteLen <= 56) {
            if (this._outputTail + byteLen >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(190 + byteLen);
            System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
            if (this._seenNameCount >= 0) {
                this._addSeenName(name.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + byteLen + 1 < this._outputEnd) {
            System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
        } else {
            this._flushBuffer();
            if (byteLen < 770) {
                System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, byteLen);
                this._outputTail += byteLen;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(bytes, 0, byteLen);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(name.getValue());
        }
    }

    private final void _writeSharedNameReference(int ix) throws IOException {
        if (ix >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + ix + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (ix < 64) {
            this._writeByte((byte)(64 + ix));
        } else {
            this._writeBytes((byte)(48 + (ix >> 8)), (byte)ix);
        }
    }

    public void writeString(String text) throws IOException {
        int ix;
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int len = text.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len > 65) {
            this._writeNonSharedString(text, len);
            return;
        }
        if (this._seenStringValueCount >= 0 && (ix = this._findSeenStringValue(text)) >= 0) {
            this._writeSharedStringValueReference(ix);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        int origOffset = this._outputTail++;
        int byteLen = this._shortUTF8Encode(text, 0, len);
        if (byteLen <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(text);
            }
            this._outputBuffer[origOffset] = byteLen == len ? (byte)(63 + byteLen) : (byte)(126 + byteLen);
        } else {
            this._outputBuffer[origOffset] = byteLen == len ? -32 : -28;
            this._outputBuffer[this._outputTail++] = -4;
        }
    }

    private final void _writeSharedStringValueReference(int ix) throws IOException {
        if (ix >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + ix + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (ix < 31) {
            this._writeByte((byte)(1 + ix));
        } else {
            this._writeBytes((byte)(236 + (ix >> 8)), (byte)ix);
        }
    }

    private final void _writeNonSharedString(String text, int len) throws IOException {
        int maxLen = len + len + len + 2;
        if (maxLen > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(text, 0, len);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + maxLen >= this._outputEnd) {
            this._flushBuffer();
        }
        int origOffset = this._outputTail;
        this._writeByte((byte)-32);
        int byteLen = this._shortUTF8Encode(text, 0, len);
        if (byteLen > len) {
            this._outputBuffer[origOffset] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        if (len <= 65 && this._seenStringValueCount >= 0 && len > 0) {
            this.writeString(new String(text, offset, len));
            return;
        }
        this._verifyValueWrite("write String value");
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len <= 64) {
            int typeToken;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int origOffset = this._outputTail++;
            int byteLen = this._shortUTF8Encode(text, offset, offset + len);
            if (byteLen <= 64) {
                typeToken = byteLen == len ? (int)((byte)(63 + byteLen)) : (int)((byte)(126 + byteLen));
            } else {
                typeToken = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[origOffset] = typeToken;
        } else {
            int maxLen = len + len + len + 2;
            if (maxLen <= this._outputBuffer.length) {
                if (this._outputTail + maxLen >= this._outputEnd) {
                    this._flushBuffer();
                }
                int origOffset = this._outputTail;
                this._writeByte((byte)-28);
                int byteLen = this._shortUTF8Encode(text, offset, offset + len);
                if (byteLen == len) {
                    this._outputBuffer[origOffset] = -32;
                }
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._mediumUTF8Encode(text, offset, offset + len);
                this._writeByte((byte)-4);
            }
        }
    }

    public final void writeString(SerializableString sstr) throws IOException {
        int ix;
        this._verifyValueWrite("write String value");
        String str = sstr.getValue();
        int len = str.length();
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (len <= 65 && this._seenStringValueCount >= 0 && (ix = this._findSeenStringValue(str)) >= 0) {
            this._writeSharedStringValueReference(ix);
            return;
        }
        byte[] raw = sstr.asUnquotedUTF8();
        int byteLen = raw.length;
        if (byteLen <= 64) {
            if (this._outputTail + byteLen + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            int typeToken = byteLen == len ? 63 + byteLen : 126 + byteLen;
            this._outputBuffer[this._outputTail++] = (byte)typeToken;
            System.arraycopy(raw, 0, this._outputBuffer, this._outputTail, byteLen);
            this._outputTail += byteLen;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(sstr.getValue());
            }
        } else {
            byte typeToken = byteLen == len ? (byte)-32 : -28;
            this._writeByte(typeToken);
            this._writeBytes(raw, 0, raw.length);
            this._writeByte((byte)-4);
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write String value");
        if (len == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenStringValueCount >= 0) {
            throw new UnsupportedOperationException("Can not use direct UTF-8 write methods when 'Feature.CHECK_SHARED_STRING_VALUES' enabled");
        }
        if (len <= 65) {
            if (this._outputTail + len >= this._outputEnd) {
                this._flushBuffer();
            }
            if (len == 1) {
                this._outputBuffer[this._outputTail++] = 64;
                this._outputBuffer[this._outputTail++] = text[offset];
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(126 + len);
                System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
                this._outputTail += len;
            }
        } else {
            int maxLen = len + len + len + 2;
            if (maxLen <= this._outputBuffer.length) {
                if (this._outputTail + maxLen >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._outputBuffer[this._outputTail++] = -28;
                System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
                this._outputTail += len;
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._writeBytes(text, offset, len);
                this._writeByte((byte)-4);
            }
        }
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeRawUTF8String(text, offset, len);
    }

    public void writeRaw(String text) throws IOException {
        throw this._notSupported();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw this._notSupported();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw this._notSupported();
    }

    public void writeRaw(char c) throws IOException {
        throw this._notSupported();
    }

    public void writeRawValue(String text) throws IOException {
        throw this._notSupported();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        throw this._notSupported();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        throw this._notSupported();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(data, offset, len);
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(len);
            this._writeBytes(data, offset, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeBinary(InputStream data, int dataLength) throws IOException {
        int missing;
        if (dataLength < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
            try {
                missing = this._write7BitBinaryWithLength(data, dataLength, encodingBuffer);
            }
            finally {
                this._ioContext.releaseBase64Buffer(encodingBuffer);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(dataLength);
            missing = this._writeBytes(data, dataLength);
        }
        if (missing > 0) {
            this._reportError("Too few bytes available: missing " + missing + " bytes (out of " + dataLength + ")");
        }
        return dataLength;
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        return this.writeBinary(data, dataLength);
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (state) {
            this._writeByte((byte)35);
        } else {
            this._writeByte((byte)34);
        }
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        i = SmileUtil.zigzagEncode(i);
        if (i <= 63 && i >= 0) {
            if (i <= 31) {
                this._writeByte((byte)(192 + i));
                return;
            }
            this._writeBytes((byte)36, (byte)(128 + i));
            return;
        }
        byte b0 = (byte)(128 + (i & 0x3F));
        if ((i >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)i, b0);
            return;
        }
        byte b1 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)i, b1, b0);
            return;
        }
        byte b2 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)i, b2, b1, b0);
            return;
        }
        byte b3 = (byte)(i & 0x7F);
        this._writeBytes((byte)36, (byte)(i >> 7), b3, b2, b1, b0);
    }

    private final int _writeNumberNoChecks(int ptr, int i) throws IOException {
        byte[] output = this._outputBuffer;
        if ((i = SmileUtil.zigzagEncode(i)) <= 63 && i >= 0) {
            if (i <= 31) {
                output[ptr++] = (byte)(192 + i);
                return ptr;
            }
            output[ptr++] = 36;
            output[ptr++] = (byte)(128 + i);
            return ptr;
        }
        output[ptr++] = 36;
        byte b0 = (byte)(128 + (i & 0x3F));
        if ((i >>>= 6) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b0;
            return ptr;
        }
        byte b1 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b2 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b3 = (byte)(i & 0x7F);
        output[ptr++] = (byte)(i >> 7);
        output[ptr++] = b3;
        output[ptr++] = b2;
        output[ptr++] = b1;
        output[ptr++] = b0;
        return ptr;
    }

    public void writeNumber(long l) throws IOException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        l = SmileUtil.zigzagEncode(l);
        int i = (int)l;
        byte b0 = (byte)(128 + (i & 0x3F));
        byte b1 = (byte)(i >> 6 & 0x7F);
        byte b2 = (byte)(i >> 13 & 0x7F);
        byte b3 = (byte)(i >> 20 & 0x7F);
        byte b4 = (byte)((int)(l >>>= 27) & 0x7F);
        i = (int)(l >> 7);
        if (i == 0) {
            this._writeBytes((byte)37, b4, b3, b2, b1, b0);
            return;
        }
        if (i <= 127) {
            this._writeBytes((byte)37, (byte)i);
            this._writeBytes(b4, b3, b2, b1, b0);
            return;
        }
        byte b5 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b6 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i, b6);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b7 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)i, b7, b6);
            this._writeBytes(b5, b4, b3, b2, b1, b0);
            return;
        }
        byte b8 = (byte)(i & 0x7F);
        this._writeBytes((byte)37, (byte)(i >>= 7), b8, b7, b6);
        this._writeBytes(b5, b4, b3, b2, b1, b0);
    }

    private final int _writeNumberNoChecks(int ptr, long l) throws IOException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return this._writeNumberNoChecks(ptr, (int)l);
        }
        l = SmileUtil.zigzagEncode(l);
        int i = (int)l;
        byte b0 = (byte)(128 + (i & 0x3F));
        byte b1 = (byte)(i >> 6 & 0x7F);
        byte b2 = (byte)(i >> 13 & 0x7F);
        byte b3 = (byte)(i >> 20 & 0x7F);
        byte b4 = (byte)((int)(l >>>= 27) & 0x7F);
        byte[] output = this._outputBuffer;
        output[ptr++] = 37;
        i = (int)(l >> 7);
        if (i == 0) {
            output[ptr++] = b4;
            output[ptr++] = b3;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        if (i <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b4;
            output[ptr++] = b3;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b5 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b5;
            output[ptr++] = b4;
            output[ptr++] = b3;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b6 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b6;
            output[ptr++] = b5;
            output[ptr++] = b4;
            output[ptr++] = b3;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b7 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            output[ptr++] = (byte)i;
            output[ptr++] = b7;
            output[ptr++] = b6;
            output[ptr++] = b5;
            output[ptr++] = b4;
            output[ptr++] = b3;
            output[ptr++] = b2;
            output[ptr++] = b1;
            output[ptr++] = b0;
            return ptr;
        }
        byte b8 = (byte)(i & 0x7F);
        output[ptr++] = (byte)(i >>= 7);
        output[ptr++] = b8;
        output[ptr++] = b7;
        output[ptr++] = b6;
        output[ptr++] = b5;
        output[ptr++] = b4;
        output[ptr++] = b3;
        output[ptr++] = b2;
        output[ptr++] = b1;
        output[ptr++] = b0;
        return ptr;
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        byte[] data = v.toByteArray();
        this._write7BitBinaryWithLength(data, 0, data.length);
    }

    public void writeNumber(double d) throws IOException {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l = Double.doubleToRawLongBits(d);
        this._outputBuffer[this._outputTail++] = 41;
        int hi5 = (int)(l >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(hi5 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((hi5 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(hi5 >>= 7);
        this._outputTail += 5;
        int mid = (int)(l >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(mid & 0x7F);
        int lo4 = (int)l;
        this._outputBuffer[this._outputTail + 3] = (byte)(lo4 & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((lo4 >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    private final int _writeNumberNoChecks(int ptr, double d) throws IOException {
        long l = Double.doubleToRawLongBits(d);
        byte[] output = this._outputBuffer;
        output[ptr++] = 41;
        int hi5 = (int)(l >>> 35);
        output[ptr + 4] = (byte)(hi5 & 0x7F);
        output[ptr + 3] = (byte)((hi5 >>= 7) & 0x7F);
        output[ptr + 2] = (byte)((hi5 >>= 7) & 0x7F);
        output[ptr + 1] = (byte)((hi5 >>= 7) & 0x7F);
        output[ptr] = (byte)(hi5 >>= 7);
        ptr += 5;
        int mid = (int)(l >> 28);
        output[ptr++] = (byte)(mid & 0x7F);
        int lo4 = (int)l;
        output[ptr + 3] = (byte)(lo4 & 0x7F);
        output[ptr + 2] = (byte)((lo4 >>= 7) & 0x7F);
        output[ptr + 1] = (byte)((lo4 >>= 7) & 0x7F);
        output[ptr] = (byte)((lo4 >>= 7) & 0x7F);
        return ptr + 4;
    }

    public void writeNumber(float f) throws IOException {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int i = Float.floatToRawIntBits(f);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(i & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((i >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((i >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((i >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((i >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int scale = dec.scale();
        this._writeSignedVInt(scale);
        BigInteger unscaled = dec.unscaledValue();
        byte[] data = unscaled.toByteArray();
        this._write7BitBinaryWithLength(data, 0, data.length);
    }

    public void writeNumber(String encodedValue) throws IOException {
        char c;
        int i;
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        int len = encodedValue.length();
        boolean neg = encodedValue.startsWith("-");
        int n = i = neg ? 1 : 0;
        while ((c = encodedValue.charAt(i)) <= '9' && c >= '0') {
            if (++i != len) continue;
            this._writeIntegralNumber(encodedValue, neg);
            return;
        }
        this._writeDecimalNumber(encodedValue);
    }

    protected void _writeIntegralNumber(String enc, boolean neg) throws IOException {
        int len = enc.length();
        if (neg) {
            --len;
        }
        try {
            if (len <= 9) {
                this.writeNumber(Integer.parseInt(enc));
            } else if (len <= 18) {
                this.writeNumber(Long.parseLong(enc));
            } else {
                this.writeNumber(new BigInteger(enc));
            }
        }
        catch (NumberFormatException e) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + enc + "'); can not write using Smile format", (JsonGenerator)this);
        }
    }

    protected void _writeDecimalNumber(String enc) throws IOException {
        try {
            this.writeNumber(new BigDecimal(enc));
        }
        catch (NumberFormatException e) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + enc + "'); can not write using Smile format", (JsonGenerator)this);
        }
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    public final void flush() throws IOException {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    public void close() throws IOException {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext ctxt;
                if ((ctxt = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean wasClosed = this._closed;
        super.close();
        if (!wasClosed && this.isEnabled(Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] str, int i, int end) {
        int ptr = this._outputTail;
        byte[] outBuf = this._outputBuffer;
        do {
            char c;
            if ((c = str[i]) > '\u007f') {
                return this._shortUTF8Encode2(str, i, end, ptr);
            }
            outBuf[ptr++] = (byte)c;
        } while (++i < end);
        int codedLen = ptr - this._outputTail;
        this._outputTail = ptr;
        return codedLen;
    }

    private final int _shortUTF8Encode2(char[] str, int i, int end, int outputPtr) {
        byte[] outBuf = this._outputBuffer;
        while (i < end) {
            int c;
            if ((c = str[i++]) <= 127) {
                outBuf[outputPtr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                outBuf[outputPtr++] = (byte)(0xC0 | c >> 6);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                outBuf[outputPtr++] = (byte)(0xE0 | c >> 12);
                outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (i >= end) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str[i++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            outBuf[outputPtr++] = (byte)(0xF0 | c >> 18);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
        }
        int codedLen = outputPtr - this._outputTail;
        this._outputTail = outputPtr;
        return codedLen;
    }

    private final int _shortUTF8Encode(String str, int i, int end) {
        int ptr = this._outputTail;
        byte[] outBuf = this._outputBuffer;
        do {
            char c;
            if ((c = str.charAt(i)) > '\u007f') {
                return this._shortUTF8Encode2(str, i, end, ptr);
            }
            outBuf[ptr++] = (byte)c;
        } while (++i < end);
        int codedLen = ptr - this._outputTail;
        this._outputTail = ptr;
        return codedLen;
    }

    private final int _shortUTF8Encode2(String str, int i, int end, int outputPtr) {
        byte[] outBuf = this._outputBuffer;
        while (i < end) {
            int c;
            if ((c = str.charAt(i++)) <= 127) {
                outBuf[outputPtr++] = (byte)c;
                continue;
            }
            if (c < 2048) {
                outBuf[outputPtr++] = (byte)(0xC0 | c >> 6);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                outBuf[outputPtr++] = (byte)(0xE0 | c >> 12);
                outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
                outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (i >= end) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str.charAt(i++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            outBuf[outputPtr++] = (byte)(0xF0 | c >> 18);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            outBuf[outputPtr++] = (byte)(0x80 | c & 0x3F);
        }
        int codedLen = outputPtr - this._outputTail;
        this._outputTail = outputPtr;
        return codedLen;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] str, int inputPtr, int inputEnd) throws IOException {
        int bufferEnd = this._outputEnd - 4;
        block0: while (inputPtr < inputEnd) {
            int c;
            if (this._outputTail >= bufferEnd) {
                this._flushBuffer();
            }
            if ((c = str[inputPtr++]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)c;
                int maxInCount = inputEnd - inputPtr;
                int maxOutCount = bufferEnd - this._outputTail;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += inputPtr;
                while (true) {
                    if (inputPtr >= maxInCount) continue block0;
                    if ((c = str[inputPtr++]) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)c;
                }
            }
            if (c < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (inputPtr >= inputEnd) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str[inputPtr++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | c >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(String str, int inputPtr, int inputEnd) throws IOException {
        int bufferEnd = this._outputEnd - 4;
        block0: while (inputPtr < inputEnd) {
            int c;
            if (this._outputTail >= bufferEnd) {
                this._flushBuffer();
            }
            if ((c = str.charAt(inputPtr++)) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)c;
                int maxInCount = inputEnd - inputPtr;
                int maxOutCount = bufferEnd - this._outputTail;
                if (maxInCount > maxOutCount) {
                    maxInCount = maxOutCount;
                }
                maxInCount += inputPtr;
                while (true) {
                    if (inputPtr >= maxInCount) continue block0;
                    if ((c = (int)str.charAt(inputPtr++)) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)c;
                }
            }
            if (c < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < 55296 || c > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c > 56319) {
                this._throwIllegalSurrogate(c);
            }
            if (inputPtr >= inputEnd) {
                this._throwIllegalSurrogate(c);
            }
            if ((c = this._convertSurrogate(c, str.charAt(inputPtr++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(c);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | c >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | c & 0x3F);
        }
        return;
    }

    private int _convertSurrogate(int firstPart, int secondPart) {
        if (secondPart < 56320 || secondPart > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(firstPart) + ", second 0x" + Integer.toHexString(secondPart) + "; illegal combination");
        }
        return 65536 + (firstPart - 55296 << 10) + (secondPart - 56320);
    }

    private void _throwIllegalSurrogate(int code) {
        if (code > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (code >= 55296) {
            if (code <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(code) + ") to output");
    }

    private final void _ensureRoomForOutput(int needed) throws IOException {
        if (this._outputTail + needed >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte b) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b;
    }

    private final void _writeBytes(byte b1, byte b2) throws IOException {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3) throws IOException {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4, byte b5) throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
        this._outputBuffer[this._outputTail++] = b5;
    }

    private final void _writeBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6) throws IOException {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b1;
        this._outputBuffer[this._outputTail++] = b2;
        this._outputBuffer[this._outputTail++] = b3;
        this._outputBuffer[this._outputTail++] = b4;
        this._outputBuffer[this._outputTail++] = b5;
        this._outputBuffer[this._outputTail++] = b6;
    }

    private final void _writeBytes(byte[] data, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this._outputTail + len >= this._outputEnd) {
            this._writeBytesLong(data, offset, len);
            return;
        }
        System.arraycopy(data, offset, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    private final int _writeBytes(InputStream in, int bytesLeft) throws IOException {
        while (bytesLeft > 0) {
            int count;
            int room = this._outputEnd - this._outputTail;
            if (room <= 0) {
                this._flushBuffer();
                room = this._outputEnd - this._outputTail;
            }
            if (room > bytesLeft) {
                room = bytesLeft;
            }
            if ((count = in.read(this._outputBuffer, this._outputTail, room)) < 0) break;
            this._outputTail += count;
            bytesLeft -= count;
        }
        return bytesLeft;
    }

    private final void _writeBytesLong(byte[] data, int offset, int len) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int currLen = Math.min(len, this._outputEnd - this._outputTail);
            System.arraycopy(data, offset, this._outputBuffer, this._outputTail, currLen);
            this._outputTail += currLen;
            if ((len -= currLen) == 0) break;
            offset += currLen;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int i) throws IOException {
        this._ensureRoomForOutput(5);
        byte b0 = (byte)(128 + (i & 0x3F));
        if ((i >>= 6) <= 127) {
            if (i > 0) {
                this._outputBuffer[this._outputTail++] = (byte)i;
            }
            this._outputBuffer[this._outputTail++] = b0;
            return;
        }
        byte b1 = (byte)(i & 0x7F);
        if ((i >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)i;
            this._outputBuffer[this._outputTail++] = b1;
            this._outputBuffer[this._outputTail++] = b0;
        } else {
            byte b2 = (byte)(i & 0x7F);
            if ((i >>= 7) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)i;
                this._outputBuffer[this._outputTail++] = b2;
                this._outputBuffer[this._outputTail++] = b1;
                this._outputBuffer[this._outputTail++] = b0;
            } else {
                byte b3 = (byte)(i & 0x7F);
                this._outputBuffer[this._outputTail++] = (byte)(i >> 7);
                this._outputBuffer[this._outputTail++] = b3;
                this._outputBuffer[this._outputTail++] = b2;
                this._outputBuffer[this._outputTail++] = b1;
                this._outputBuffer[this._outputTail++] = b0;
            }
        }
    }

    private void _writeSignedVInt(int input) throws IOException {
        this._writePositiveVInt(SmileUtil.zigzagEncode(input));
    }

    protected void _write7BitBinaryWithLength(byte[] data, int offset, int len) throws IOException {
        int i;
        this._writePositiveVInt(len);
        while (len >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            i = data[offset++];
            this._outputBuffer[this._outputTail++] = (byte)(i >> 1 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 2 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 3 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 4 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 5 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 6 & 0x7F);
            i = i << 8 | data[offset++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(i & 0x7F);
            len -= 7;
        }
        if (len > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            i = data[offset++];
            this._outputBuffer[this._outputTail++] = (byte)(i >> 1 & 0x7F);
            if (len > 1) {
                i = (i & 1) << 8 | data[offset++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(i >> 2 & 0x7F);
                if (len > 2) {
                    i = (i & 3) << 8 | data[offset++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(i >> 3 & 0x7F);
                    if (len > 3) {
                        i = (i & 7) << 8 | data[offset++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(i >> 4 & 0x7F);
                        if (len > 4) {
                            i = (i & 0xF) << 8 | data[offset++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(i >> 5 & 0x7F);
                            if (len > 5) {
                                i = (i & 0x1F) << 8 | data[offset++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(i >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(i & 0x3F);
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(i & 0x1F);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(i & 0xF);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(i & 7);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(i & 3);
                }
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(i & 1);
            }
        }
    }

    protected int _write7BitBinaryWithLength(InputStream in, int bytesLeft, byte[] buffer) throws IOException {
        int i;
        this._writePositiveVInt(bytesLeft);
        int inputPtr = 0;
        int inputEnd = 0;
        int lastFullOffset = -7;
        while (bytesLeft >= 7) {
            if (inputPtr > lastFullOffset) {
                inputEnd = this._readMore(in, buffer, inputPtr, inputEnd, bytesLeft);
                inputPtr = 0;
                if (inputEnd < 7) {
                    bytesLeft -= inputEnd;
                    break;
                }
                lastFullOffset = inputEnd - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            i = buffer[inputPtr++];
            this._outputBuffer[this._outputTail++] = (byte)(i >> 1 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 2 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 3 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 4 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 5 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 6 & 0x7F);
            i = i << 8 | buffer[inputPtr++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(i >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(i & 0x7F);
            bytesLeft -= 7;
        }
        if (bytesLeft > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            inputEnd = this._readMore(in, buffer, inputPtr, inputEnd, bytesLeft);
            inputPtr = 0;
            if (inputEnd > 0) {
                bytesLeft -= inputEnd;
                i = buffer[inputPtr++];
                this._outputBuffer[this._outputTail++] = (byte)(i >> 1 & 0x7F);
                if (inputEnd > 1) {
                    i = (i & 1) << 8 | buffer[inputPtr++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(i >> 2 & 0x7F);
                    if (inputEnd > 2) {
                        i = (i & 3) << 8 | buffer[inputPtr++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(i >> 3 & 0x7F);
                        if (inputEnd > 3) {
                            i = (i & 7) << 8 | buffer[inputPtr++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(i >> 4 & 0x7F);
                            if (inputEnd > 4) {
                                i = (i & 0xF) << 8 | buffer[inputPtr++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(i >> 5 & 0x7F);
                                if (inputEnd > 5) {
                                    i = (i & 0x1F) << 8 | buffer[inputPtr++] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(i >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(i & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(i & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(i & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(i & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(i & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(i & 1);
                }
            }
        }
        return bytesLeft;
    }

    private int _readMore(InputStream in, byte[] readBuffer, int inputPtr, int inputEnd, int maxRead) throws IOException {
        int length;
        int i = 0;
        while (inputPtr < inputEnd) {
            readBuffer[i++] = readBuffer[inputPtr++];
        }
        inputPtr = 0;
        inputEnd = i;
        maxRead = Math.min(maxRead, readBuffer.length);
        while ((length = maxRead - inputEnd) != 0) {
            int count = in.read(readBuffer, inputEnd, length);
            if (count < 0) {
                return inputEnd;
            }
            if ((inputEnd += count) < 7) continue;
        }
        return inputEnd;
    }

    protected void _releaseBuffers() {
        Object[] valueBuf;
        Object[] nameBuf;
        byte[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(buf);
        }
        if ((nameBuf = this._seenNames) != null && nameBuf.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(nameBuf, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SharedStringNode[])nameBuf);
        }
        if ((valueBuf = this._seenStringValues) != null && valueBuf.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(valueBuf, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SharedStringNode[])valueBuf);
        }
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String name) {
        int hash = name.hashCode();
        SharedStringNode head = this._seenNames[hash & this._seenNames.length - 1];
        if (head == null) {
            return -1;
        }
        SharedStringNode node = head;
        if (node.value == name) {
            return node.index;
        }
        while ((node = node.next) != null) {
            if (node.value != name) continue;
            return node.index;
        }
        node = head;
        do {
            String value;
            if ((value = node.value).hashCode() != hash || !value.equals(name)) continue;
            return node.index;
        } while ((node = node.next) != null);
        return -1;
    }

    private final void _addSeenName(String name) {
        int ref;
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SharedStringNode[] old = this._seenNames;
                this._seenNames = new SharedStringNode[1024];
                int mask = 1023;
                for (SharedStringNode node : old) {
                    while (node != null) {
                        int ix = node.value.hashCode() & 0x3FF;
                        SharedStringNode next = node.next;
                        node.next = this._seenNames[ix];
                        this._seenNames[ix] = node;
                        node = next;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(ref = this._seenNameCount)) {
            int ix = name.hashCode() & this._seenNames.length - 1;
            this._seenNames[ix] = new SharedStringNode(name, ref, this._seenNames[ix]);
        }
        this._seenNameCount = ref + 1;
    }

    private final int _findSeenStringValue(String text) {
        int hash = text.hashCode();
        SharedStringNode head = this._seenStringValues[hash & this._seenStringValues.length - 1];
        if (head != null) {
            SharedStringNode node = head;
            do {
                if (node.value != text) continue;
                return node.index;
            } while ((node = node.next) != null);
            node = head;
            do {
                String value;
                if ((value = node.value).hashCode() != hash || !value.equals(text)) continue;
                return node.index;
            } while ((node = node.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String text) {
        int ref;
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SharedStringNode[] old = this._seenStringValues;
                this._seenStringValues = new SharedStringNode[1024];
                int mask = 1023;
                for (SharedStringNode node : old) {
                    while (node != null) {
                        int ix = node.value.hashCode() & 0x3FF;
                        SharedStringNode next = node.next;
                        node.next = this._seenStringValues[ix];
                        this._seenStringValues[ix] = node;
                        node = next;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(ref = this._seenStringValueCount)) {
            int ix = text.hashCode() & this._seenStringValues.length - 1;
            this._seenStringValues[ix] = new SharedStringNode(text, ref, this._seenStringValues[ix]);
        }
        this._seenStringValueCount = ref + 1;
    }

    private static final boolean _validBackRef(int index) {
        return (index & 0xFF) < 254;
    }

    protected long outputOffset() {
        return this._bytesWritten + this._outputTail;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }

    protected static final class SharedStringNode {
        public final String value;
        public final int index;
        public SharedStringNode next;

        public SharedStringNode(String value, int index, SharedStringNode next) {
            this.value = value;
            this.index = index;
            this.next = next;
        }
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_HEADER(true),
        WRITE_END_MARKER(false),
        ENCODE_BINARY_AS_7BIT(true),
        CHECK_SHARED_NAMES(true),
        CHECK_SHARED_STRING_VALUES(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }
    }
}

