/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.main;

import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private final ClusterService clusterService;

    @Inject
    public TransportMainAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:monitor/main", threadPool, transportService, actionFilters, indexNameExpressionResolver, MainRequest::new);
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        assert (Node.NODE_NAME_SETTING.exists(this.settings));
        boolean available = !clusterState.getBlocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE);
        listener.onResponse(new MainResponse(Node.NODE_NAME_SETTING.get(this.settings), Version.CURRENT, clusterState.getClusterName(), clusterState.metaData().clusterUUID(), Build.CURRENT, available));
    }
}

