/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.SloppyMath;

class LatLonPointDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final double latitude;
    final double longitude;
    final double[] values;
    double bottom;
    double topValue;
    SortedNumericDocValues currentDocs;
    int minLon = Integer.MIN_VALUE;
    int maxLon = Integer.MAX_VALUE;
    int minLat = Integer.MIN_VALUE;
    int maxLat = Integer.MAX_VALUE;
    int minLon2 = Integer.MAX_VALUE;
    int setBottomCounter = 0;

    public LatLonPointDistanceComparator(String field, double latitude, double longitude, int numHits) {
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.values = new double[numHits];
    }

    public void setScorer(Scorer scorer) {
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
        if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
            Rectangle box = Rectangle.fromPointDistance((double)this.latitude, (double)this.longitude, (double)LatLonPointDistanceComparator.haversin2(this.bottom));
            this.minLat = GeoEncodingUtils.encodeLatitude((double)box.minLat);
            this.maxLat = GeoEncodingUtils.encodeLatitude((double)box.maxLat);
            if (box.crossesDateline()) {
                this.minLon = Integer.MIN_VALUE;
                this.maxLon = GeoEncodingUtils.encodeLongitude((double)box.maxLon);
                this.minLon2 = GeoEncodingUtils.encodeLongitude((double)box.minLon);
            } else {
                this.minLon = GeoEncodingUtils.encodeLongitude((double)box.minLon);
                this.maxLon = GeoEncodingUtils.encodeLongitude((double)box.maxLon);
                this.minLon2 = Integer.MAX_VALUE;
            }
        }
        ++this.setBottomCounter;
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        this.currentDocs.setDocument(doc);
        int numValues = this.currentDocs.count();
        if (numValues == 0) {
            return Double.compare(this.bottom, Double.POSITIVE_INFINITY);
        }
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            double docLongitude;
            double docLatitude;
            int longitudeBits;
            long encoded = this.currentDocs.valueAt(i);
            int latitudeBits = (int)(encoded >> 32);
            if (latitudeBits < this.minLat || latitudeBits > this.maxLat || ((longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL)) < this.minLon || longitudeBits > this.maxLon) && longitudeBits < this.minLon2 || (cmp = Math.max(cmp, Double.compare(this.bottom, SloppyMath.haversinSortKey((double)this.latitude, (double)this.longitude, (double)(docLatitude = GeoEncodingUtils.decodeLatitude((int)latitudeBits)), (double)(docLongitude = GeoEncodingUtils.decodeLongitude((int)longitudeBits)))))) <= 0) continue;
            return cmp;
        }
        return cmp;
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortKey(doc);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            LatLonDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
        return this;
    }

    public Double value(int slot) {
        return LatLonPointDistanceComparator.haversin2(this.values[slot]);
    }

    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, LatLonPointDistanceComparator.haversin2(this.sortKey(doc)));
    }

    double sortKey(int doc) {
        this.currentDocs.setDocument(doc);
        double minValue = Double.POSITIVE_INFINITY;
        int numValues = this.currentDocs.count();
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.valueAt(i);
            double docLatitude = GeoEncodingUtils.decodeLatitude((int)((int)(encoded >> 32)));
            double docLongitude = GeoEncodingUtils.decodeLongitude((int)((int)(encoded & 0xFFFFFFFFFFFFFFFFL)));
            minValue = Math.min(minValue, SloppyMath.haversinSortKey((double)this.latitude, (double)this.longitude, (double)docLatitude, (double)docLongitude));
        }
        return minValue;
    }

    static double haversin2(double partial) {
        if (Double.isInfinite(partial)) {
            return partial;
        }
        return SloppyMath.haversinMeters((double)partial);
    }
}

