/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HttpClientUtils {
    private static final Log log = LogFactory.getLog(HttpClientUtils.class);

    private HttpClientUtils() {
    }

    public static InputStream getDecompressingInputStream(HttpResponse<InputStream> resp) throws IOException {
        String encoding = resp.headers().firstValue("Content-Encoding").orElse("identity").toLowerCase(Locale.ROOT).trim();
        log.debug((Object)("HTTP server uses " + encoding + " content encoding."));
        switch (encoding) {
            case "gzip": {
                return new GZIPInputStream(resp.body());
            }
            case "deflate": {
                return new InflaterInputStream(resp.body());
            }
            case "identity": {
                return resp.body();
            }
        }
        throw new IOException("Server uses an invalid content encoding: " + encoding);
    }

    public static void sendCompressionHeaders(HttpRequest.Builder builder) {
        builder.setHeader("Accept-Encoding", "gzip, deflate, identity;q=0.3, *;q=0");
    }

    public static <T> HttpResponse<T> sendHttpRequestWithRetry(HttpClient client, HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        try {
            try {
                return client.send(request, responseBodyHandler);
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("GOAWAY")) {
                    return client.send(request, responseBodyHandler);
                }
                throw e;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Connection interrupted.");
        }
    }
}

