/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class LenientDateParser {
    private static Pattern tzpat = Pattern.compile("([\\+\\-]\\d\\d)\\:(\\d\\d)\\z");
    private static DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'", Locale.ROOT), new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT), DateFormat.getDateInstance(0, Locale.US), DateFormat.getDateInstance(2, Locale.US), DateFormat.getDateInstance(3, Locale.US), new SimpleDateFormat("yyyy-MM", Locale.ROOT), new SimpleDateFormat("yyyy", Locale.ROOT)};
    private static DateFormat[] timeFormats = new DateFormat[]{new SimpleDateFormat("HH:mm:ss.SSS'Z'", Locale.ROOT), new SimpleDateFormat("HH:mm:ss'Z'", Locale.ROOT), new SimpleDateFormat("HH:mm'Z'", Locale.ROOT), new SimpleDateFormat("HH:mm:ss.SSSZ", Locale.ROOT), new SimpleDateFormat("HH:mm:ssZ", Locale.ROOT), new SimpleDateFormat("HH:mmZ", Locale.ROOT), new SimpleDateFormat("HH:mm:ss.SSS z", Locale.ROOT), new SimpleDateFormat("HH:mm:ss z", Locale.ROOT), new SimpleDateFormat("HH:mm z", Locale.ROOT), new SimpleDateFormat("HH:mm:ss.SSS", Locale.ROOT), new SimpleDateFormat("HH:mm:ss", Locale.ROOT), new SimpleDateFormat("HH:mm", Locale.ROOT), DateFormat.getTimeInstance(0, Locale.US), DateFormat.getTimeInstance(2, Locale.US), DateFormat.getTimeInstance(3, Locale.US)};

    private LenientDateParser() {
    }

    public static synchronized Date parseDate(String date) throws ParseException {
        ParsePosition akt;
        if (date == null) {
            return null;
        }
        date = tzpat.matcher(date).replaceFirst("$1$2");
        ParsePosition pp = new ParsePosition(0);
        Date d1 = null;
        Date d2 = null;
        for (DateFormat df : dateFormats) {
            akt = new ParsePosition(pp.getIndex());
            d1 = df.parse(date, akt);
            if (akt.getErrorIndex() < 0) {
                pp = akt;
                break;
            }
            d1 = null;
        }
        for (DateFormat df : timeFormats) {
            akt = new ParsePosition(pp.getIndex());
            d2 = df.parse(date, akt);
            if (akt.getErrorIndex() < 0) {
                pp = akt;
                break;
            }
            d2 = null;
        }
        if (d1 == null && d2 == null || pp.getIndex() != date.length()) {
            throw new ParseException("Invalid date/time: " + date, pp.getIndex());
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return new Date(d1.getTime() + d2.getTime());
    }

    public static void main(String[] argv) throws Exception {
        for (String d : argv) {
            System.out.println(LenientDateParser.parseDate(d));
        }
    }

    static {
        TimeZone UTC = TimeZone.getTimeZone(ZoneOffset.UTC);
        for (DateFormat df : dateFormats) {
            df.setTimeZone(UTC);
            df.setLenient(true);
        }
        TimeZone tz = TimeZone.getDefault();
        int c = timeFormats.length;
        for (int i = 0; i < c; ++i) {
            DateFormat df = timeFormats[i];
            df.setTimeZone(tz);
            df.setLenient(true);
        }
        timeFormats[0].setTimeZone(UTC);
        timeFormats[0].setLenient(false);
        timeFormats[1].setTimeZone(UTC);
        timeFormats[1].setLenient(false);
        timeFormats[2].setTimeZone(UTC);
        timeFormats[2].setLenient(false);
    }
}

