/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogUtil {
    static final Log log = LogFactory.getLog(LogUtil.class);
    private static Method TRACE = null;
    private static Method DEBUG = null;
    private static Method INFO = null;
    private static Method WARN = null;
    private static Method ERROR = null;
    private static Method FATAL = null;

    private LogUtil() {
    }

    public static PrintStream getTraceStream(Log logger) {
        return LogUtil.getLogStream(logger, TRACE);
    }

    public static PrintStream getDebugStream(Log logger) {
        return LogUtil.getLogStream(logger, DEBUG);
    }

    public static PrintStream getInfoStream(Log logger) {
        return LogUtil.getLogStream(logger, INFO);
    }

    public static PrintStream getWarnStream(Log logger) {
        return LogUtil.getLogStream(logger, WARN);
    }

    public static PrintStream getErrorStream(Log logger) {
        return LogUtil.getLogStream(logger, ERROR);
    }

    public static PrintStream getFatalStream(Log logger) {
        return LogUtil.getLogStream(logger, FATAL);
    }

    private static PrintStream getLogStream(final Log logger, final Method method) {
        try {
            return new PrintStream((OutputStream)new ByteArrayOutputStream(){
                private int scan = 0;

                private synchronized boolean hasNewline() {
                    while (this.scan < this.count) {
                        if (this.buf[this.scan] == 10 || this.buf[this.scan] == 13) {
                            return true;
                        }
                        ++this.scan;
                    }
                    return false;
                }

                @Override
                public synchronized void flush() throws IOException {
                    if (!this.hasNewline()) {
                        return;
                    }
                    try {
                        if (this.scan > 0) {
                            method.invoke((Object)logger, new String(this.buf, 0, this.scan, StandardCharsets.US_ASCII), null);
                        }
                    }
                    catch (Exception e) {
                        log.fatal((Object)("Cannot log with method [" + String.valueOf(method) + "]"), (Throwable)e);
                    }
                    while (this.scan < this.count && (this.buf[this.scan] == 10 || this.buf[this.scan] == 13)) {
                        ++this.scan;
                    }
                    byte[] b = this.toByteArray();
                    this.reset();
                    this.write(b, this.scan, b.length - this.scan);
                    this.scan = 0;
                    this.flush();
                }

                @Override
                public void close() throws IOException {
                    if (!this.hasNewline()) {
                        this.write(10);
                    }
                    this.flush();
                    super.close();
                }
            }, true, StandardCharsets.US_ASCII.name());
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue);
        }
    }

    static {
        try {
            TRACE = Log.class.getMethod("trace", Object.class, Throwable.class);
            DEBUG = Log.class.getMethod("debug", Object.class, Throwable.class);
            INFO = Log.class.getMethod("info", Object.class, Throwable.class);
            WARN = Log.class.getMethod("warn", Object.class, Throwable.class);
            ERROR = Log.class.getMethod("error", Object.class, Throwable.class);
            FATAL = Log.class.getMethod("fatal", Object.class, Throwable.class);
        }
        catch (Exception e) {
            log.fatal((Object)"Cannot init log methods", (Throwable)e);
        }
    }
}

