/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.ETag;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ETagUtils {
    private static final char COMMA = ',';
    private static final char QUOTE = '\"';
    private static final char W = 'W';
    private static final char SLASH = '/';

    public static boolean handleIfMatch(HttpServerExchange exchange, ETag etag, boolean allowWeak) {
        return ETagUtils.handleIfMatch(exchange, Collections.singletonList(etag), allowWeak);
    }

    public static boolean handleIfMatch(HttpServerExchange exchange, List<ETag> etags, boolean allowWeak) {
        return ETagUtils.handleIfMatch(exchange.getRequestHeaders().getFirst(Headers.IF_MATCH), etags, allowWeak);
    }

    public static boolean handleIfMatch(String ifMatch, ETag etag, boolean allowWeak) {
        return ETagUtils.handleIfMatch(ifMatch, Collections.singletonList(etag), allowWeak);
    }

    public static boolean handleIfMatch(String ifMatch, List<ETag> etags, boolean allowWeak) {
        if (ifMatch == null) {
            return true;
        }
        if (ifMatch.equals("*")) {
            return true;
        }
        List<ETag> parts = ETagUtils.parseETagList(ifMatch);
        for (ETag part : parts) {
            if (part.isWeak() && !allowWeak) continue;
            for (ETag tag : etags) {
                if (tag == null || tag.isWeak() && !allowWeak || !tag.getTag().equals(part.getTag())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean handleIfNoneMatch(HttpServerExchange exchange, ETag etag, boolean allowWeak) {
        return ETagUtils.handleIfNoneMatch(exchange, Collections.singletonList(etag), allowWeak);
    }

    public static boolean handleIfNoneMatch(HttpServerExchange exchange, List<ETag> etags, boolean allowWeak) {
        return ETagUtils.handleIfNoneMatch(exchange.getRequestHeaders().getFirst(Headers.IF_NONE_MATCH), etags, allowWeak);
    }

    public static boolean handleIfNoneMatch(String ifNoneMatch, ETag etag, boolean allowWeak) {
        return ETagUtils.handleIfNoneMatch(ifNoneMatch, Collections.singletonList(etag), allowWeak);
    }

    public static boolean handleIfNoneMatch(String ifNoneMatch, List<ETag> etags, boolean allowWeak) {
        if (ifNoneMatch == null) {
            return true;
        }
        List<ETag> parts = ETagUtils.parseETagList(ifNoneMatch);
        for (ETag part : parts) {
            if (part.getTag().equals("*")) {
                return false;
            }
            if (part.isWeak() && !allowWeak) continue;
            for (ETag tag : etags) {
                if (tag == null || tag.isWeak() && !allowWeak || !tag.getTag().equals(part.getTag())) continue;
                return false;
            }
        }
        return true;
    }

    public static List<ETag> parseETagList(String header) {
        char[] headerChars = header.toCharArray();
        ArrayList<ETag> response = new ArrayList<ETag>();
        SearchingFor searchingFor = SearchingFor.START_OF_VALUE;
        Object currentToken = null;
        int valueStart = 0;
        boolean weak = false;
        boolean malformed = false;
        block6: for (int i = 0; i < headerChars.length; ++i) {
            switch (searchingFor) {
                case START_OF_VALUE: {
                    if (headerChars[i] == ',' || Character.isWhitespace(headerChars[i])) continue block6;
                    if (headerChars[i] == '\"') {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        weak = false;
                        malformed = false;
                        continue block6;
                    }
                    if (headerChars[i] != 'W') continue block6;
                    searchingFor = SearchingFor.WEAK_SLASH;
                    continue block6;
                }
                case WEAK_SLASH: {
                    if (headerChars[i] == '\"') {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        weak = true;
                        malformed = false;
                        continue block6;
                    }
                    if (headerChars[i] == '/') continue block6;
                    malformed = true;
                    searchingFor = SearchingFor.END_OF_VALUE;
                    continue block6;
                }
                case LAST_QUOTE: {
                    if (headerChars[i] != '\"') continue block6;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    response.add(new ETag(weak, value.trim()));
                    searchingFor = SearchingFor.START_OF_VALUE;
                    continue block6;
                }
                case END_OF_VALUE: {
                    if (headerChars[i] != ',' && !Character.isWhitespace(headerChars[i]) || malformed) continue block6;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    response.add(new ETag(weak, value.trim()));
                    searchingFor = SearchingFor.START_OF_VALUE;
                }
            }
        }
        if (!(searchingFor != SearchingFor.END_OF_VALUE && searchingFor != SearchingFor.LAST_QUOTE || malformed)) {
            String value = String.valueOf(headerChars, valueStart, headerChars.length - valueStart);
            response.add(new ETag(weak, value.trim()));
        }
        return response;
    }

    public static ETag getETag(HttpServerExchange exchange) {
        String tag = exchange.getResponseHeaders().getFirst(Headers.ETAG);
        if (tag == null) {
            return null;
        }
        char[] headerChars = tag.toCharArray();
        SearchingFor searchingFor = SearchingFor.START_OF_VALUE;
        int valueStart = 0;
        boolean weak = false;
        boolean malformed = false;
        block6: for (int i = 0; i < headerChars.length; ++i) {
            switch (searchingFor) {
                case START_OF_VALUE: {
                    if (headerChars[i] == ',' || Character.isWhitespace(headerChars[i])) continue block6;
                    if (headerChars[i] == '\"') {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        weak = false;
                        malformed = false;
                        continue block6;
                    }
                    if (headerChars[i] != 'W') continue block6;
                    searchingFor = SearchingFor.WEAK_SLASH;
                    continue block6;
                }
                case WEAK_SLASH: {
                    if (headerChars[i] == '\"') {
                        valueStart = i + 1;
                        searchingFor = SearchingFor.LAST_QUOTE;
                        weak = true;
                        malformed = false;
                        continue block6;
                    }
                    if (headerChars[i] == '/') continue block6;
                    return null;
                }
                case LAST_QUOTE: {
                    if (headerChars[i] != '\"') continue block6;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    return new ETag(weak, value.trim());
                }
                case END_OF_VALUE: {
                    if (headerChars[i] != ',' && !Character.isWhitespace(headerChars[i]) || malformed) continue block6;
                    String value = String.valueOf(headerChars, valueStart, i - valueStart);
                    return new ETag(weak, value.trim());
                }
            }
        }
        if (!(searchingFor != SearchingFor.END_OF_VALUE && searchingFor != SearchingFor.LAST_QUOTE || malformed)) {
            String value = String.valueOf(headerChars, valueStart, headerChars.length - valueStart);
            return new ETag(weak, value.trim());
        }
        return null;
    }

    static enum SearchingFor {
        START_OF_VALUE,
        LAST_QUOTE,
        END_OF_VALUE,
        WEAK_SLASH;

    }
}

