/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.config;

import de.pangaea.metadataportal.Package;
import de.pangaea.metadataportal.config.FieldConfig;
import de.pangaea.metadataportal.config.FilterConfig;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.config.HarvesterConfigTransformerSaxRule;
import de.pangaea.metadataportal.config.TargetIndexConfig;
import de.pangaea.metadataportal.config.TemplateSaxRule;
import de.pangaea.metadataportal.config.VariableConfig;
import de.pangaea.metadataportal.processor.XPathResolverImpl;
import de.pangaea.metadataportal.utils.BooleanParser;
import de.pangaea.metadataportal.utils.ElementNameCallParamRule;
import de.pangaea.metadataportal.utils.ExtendedDigester;
import de.pangaea.metadataportal.utils.HostAndPort;
import de.pangaea.metadataportal.utils.PublicForDigesterUse;
import de.pangaea.metadataportal.utils.StaticFactories;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class Config {
    private static final Log log = LogFactory.getLog(Config.class);
    public final Set<String> harvestersAndIndexes = new HashSet<String>();
    public final Map<String, TargetIndexConfig> targetIndexes = new LinkedHashMap<String, TargetIndexConfig>();
    public String typeName = "doc";
    public Path esMappingFile = null;
    public String esMapping = null;
    public String fieldnameXML = "xml";
    public String fieldnameSource = "internal-source";
    public String fieldnameDatestamp = "internal-datestamp";
    public final Map<String, FieldConfig> fields = new LinkedHashMap<String, FieldConfig>();
    public FilterConfig.FilterType filterDefault = FilterConfig.FilterType.ACCEPT;
    public final List<FilterConfig> filters = new ArrayList<FilterConfig>();
    public final List<VariableConfig> xPathVariables = new ArrayList<VariableConfig>();
    public Schema schema = null;
    public boolean haltOnSchemaError = false;
    public boolean validateWithAugmentation = true;
    public final List<InetSocketTransportAddress> esTransports = new ArrayList<InetSocketTransportAddress>();
    public Settings esSettings = null;
    public final Path file;
    private final Map<String, Templates> templatesCache = new HashMap<String, Templates>();
    ExtendedDigester dig = null;
    private final ObjectCreationFactory ES_SETTINGS_BUILDER = new AbstractObjectCreationFactory(){

        public Object createObject(Attributes attributes) throws IOException {
            Settings.Builder builder = Settings.builder();
            String src = attributes.getValue("file");
            if (src == null) {
                src = attributes.getValue("src");
            }
            if (src != null) {
                Path f = Config.this.makePathAbsolute(src);
                try (InputStream in = Files.newInputStream(f, new OpenOption[0]);){
                    builder.loadFromStream(src, in);
                }
            }
            return builder;
        }
    };
    private static final Class<?>[] DIGSTRING_PARAMS = new Class[]{ExtendedDigester.class, String.class};

    public Config(String file) throws Exception {
        this(Paths.get(file, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config(Path file) throws Exception {
        this.file = file;
        log.info((Object)Package.getFullPackageDescription());
        try {
            this.dig = new ExtendedDigester();
            this.dig.setNamespaceAware(true);
            this.dig.setValidating(false);
            this.dig.setXIncludeAware(true);
            this.dig.setRulesWithInvalidElementCheck((Rules)new ExtendedBaseRules());
            this.dig.setRuleNamespaceURI("urn:java:" + this.getClass().getName());
            this.dig.addDoNothing("config");
            this.dig.addDoNothing("config/metadata");
            this.dig.addDoNothing("config/metadata/variables");
            this.dig.addObjectCreate("config/metadata/variables/variable", VariableConfig.class);
            this.dig.addSetNext("config/metadata/variables/variable", "addVariable");
            this.dig.addCallMethod("config/metadata/variables/variable", "setName", 2, DIGSTRING_PARAMS);
            this.dig.addObjectParam("config/metadata/variables/variable", 0, (Object)this.dig);
            this.dig.addCallParam("config/metadata/variables/variable", 1, "name");
            this.dig.addCallMethod("config/metadata/variables/variable", "setXPath", 2, DIGSTRING_PARAMS);
            this.dig.addObjectParam("config/metadata/variables/variable", 0, (Object)this.dig);
            this.dig.addCallParam("config/metadata/variables/variable", 1);
            this.dig.addObjectCreate("config/metadata/variables/variable-template", VariableConfig.class);
            this.dig.addSetNext("config/metadata/variables/variable-template", "addVariable");
            this.dig.addCallMethod("config/metadata/variables/variable-template", "setName", 2, DIGSTRING_PARAMS);
            this.dig.addObjectParam("config/metadata/variables/variable-template", 0, (Object)this.dig);
            this.dig.addCallParam("config/metadata/variables/variable-template", 1, "name");
            this.dig.addRule("config/metadata/variables/variable-template", new TemplateSaxRule(this));
            this.dig.addCallMethod("config/metadata/filters", "setFilterDefault", 1);
            this.dig.addCallParam("config/metadata/filters", 0, "default");
            this.dig.addObjectCreate("config/metadata/filters/*", FilterConfig.class);
            this.dig.addSetNext("config/metadata/filters/*", "addFilter");
            this.dig.addCallMethod("config/metadata/filters/*", "setXPath", 2, DIGSTRING_PARAMS);
            this.dig.addObjectParam("config/metadata/filters/*", 0, (Object)this.dig);
            this.dig.addCallParam("config/metadata/filters/*", 1);
            this.dig.addDoNothing("config/metadata/fields");
            this.dig.addCallMethod("config/metadata/fields/xml-field", "setXMLField", 1);
            this.dig.addCallParam("config/metadata/fields/xml-field", 0, "name");
            this.dig.addCallMethod("config/metadata/fields/source-field", "setSourceField", 1);
            this.dig.addCallParam("config/metadata/fields/source-field", 0, "name");
            this.dig.addCallMethod("config/metadata/fields/datestamp-field", "setDatestampField", 1);
            this.dig.addCallParam("config/metadata/fields/datestamp-field", 0, "name");
            this.dig.addObjectCreate("config/metadata/fields/field", FieldConfig.class);
            this.dig.addSetNext("config/metadata/fields/field", "addField");
            String[] propAttr = new String[]{"datatype", "src"};
            String[] propMapping = new String[]{"dataType", null};
            SetPropertiesRule r = new SetPropertiesRule(propAttr, propMapping);
            r.setIgnoreMissingProperty(false);
            this.dig.addRule("config/metadata/fields/field", (Rule)r);
            this.dig.addCallMethod("config/metadata/fields/field", "setXPath", 2, DIGSTRING_PARAMS);
            this.dig.addObjectParam("config/metadata/fields/field", 0, (Object)this.dig);
            this.dig.addCallParam("config/metadata/fields/field", 1);
            this.dig.addObjectCreate("config/metadata/fields/field-template", FieldConfig.class);
            this.dig.addSetNext("config/metadata/fields/field-template", "addField");
            r = new SetPropertiesRule(propAttr, propMapping);
            r.setIgnoreMissingProperty(false);
            this.dig.addRule("config/metadata/fields/field-template", (Rule)r);
            this.dig.addRule("config/metadata/fields/field-template", new TemplateSaxRule(this));
            this.dig.addDoNothing("config/metadata/schema");
            this.dig.addCallMethod("config/metadata/schema/url", "setSchema", 2);
            this.dig.addCallParam("config/metadata/schema/url", 0, "namespace");
            this.dig.addCallParam("config/metadata/schema/url", 1);
            this.dig.addCallMethod("config/metadata/schema/haltOnError", "setHaltOnSchemaError", 0);
            this.dig.addCallMethod("config/metadata/schema/augmentation", "setAugmentation", 0);
            this.dig.addDoNothing("config/metadata/elasticsearchMapping");
            this.dig.addCallMethod("config/metadata/elasticsearchMapping/typeName", "setTypeName", 0);
            this.dig.addCallMethod("config/metadata/elasticsearchMapping/file", "setEsMappingFile", 0);
            this.dig.addDoNothing("config/sources");
            this.dig.addFactoryCreate("config/sources", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) {
                    return new TargetIndexConfig(Config.this, attributes.getValue("targetIndex"));
                }
            });
            this.dig.addSetNext("config/sources", "addTargetIndex");
            this.dig.addDoNothing("config/sources/targetIndex");
            this.dig.addCallMethod("config/sources/targetIndex/nameSuffix1", "setNameSuffix1", 0);
            this.dig.addCallMethod("config/sources/targetIndex/nameSuffix2", "setNameSuffix2", 0);
            this.dig.addFactoryCreate("config/sources/targetIndex/settings", this.ES_SETTINGS_BUILDER);
            this.dig.addSetNext("config/sources/targetIndex/settings", "setIndexSettings");
            this.dig.addCallMethod("config/sources/targetIndex/settings/*", "put", 2);
            this.dig.addRule("config/sources/targetIndex/settings/*", new ElementNameCallParamRule(0));
            this.dig.addCallParam("config/sources/targetIndex/settings/*", 1);
            this.dig.addCallMethod("config/sources/targetIndex/alias", "addAlias", 2);
            this.dig.addCallParam("config/sources/targetIndex/alias", 0, "name");
            this.dig.addCallParam("config/sources/targetIndex/alias", 1);
            this.dig.addDoNothing("config/sources/globalProperties");
            this.dig.addCallMethod("config/sources/globalProperties/*", "addGlobalHarvesterProperty", 0);
            this.dig.addFactoryCreate("config/sources/harvester", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) {
                    return new HarvesterConfig(Config.this, (TargetIndexConfig)this.getDigester().peek(), attributes.getValue("id"));
                }
            });
            this.dig.addSetNext("config/sources/harvester", "addHarvester");
            this.dig.addCallMethod("config/sources/harvester/class", "setHarvesterClass", 0);
            this.dig.addRule("config/sources/harvester/transform", new HarvesterConfigTransformerSaxRule(this));
            this.dig.addDoNothing("config/sources/harvester/properties");
            this.dig.addCallMethod("config/sources/harvester/properties/*", "addHarvesterProperty", 0);
            this.dig.addDoNothing("config/elasticsearchCluster");
            this.dig.addCallMethod("config/elasticsearchCluster/address", "addEsAddress", 0);
            this.dig.addFactoryCreate("config/elasticsearchCluster/settings", this.ES_SETTINGS_BUILDER);
            this.dig.addSetNext("config/elasticsearchCluster/settings", "setEsSettings");
            this.dig.addCallMethod("config/elasticsearchCluster/settings/*", "put", 2);
            this.dig.addRule("config/elasticsearchCluster/settings/*", new ElementNameCallParamRule(0));
            this.dig.addCallParam("config/elasticsearchCluster/settings/*", 1);
            try {
                this.dig.push(this);
                this.dig.parse(file.toUri().toURL());
            }
            catch (SAXException saxe) {
                Throwable e = saxe;
                if (saxe.getException() != null) {
                    e = saxe.getException();
                }
                if (e instanceof InvocationTargetException) {
                    e = ((Throwable)e).getCause();
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw saxe;
            }
        }
        finally {
            this.dig = null;
        }
        for (TargetIndexConfig iconf : this.targetIndexes.values()) {
            iconf.check();
        }
        this.templatesCache.clear();
    }

    public final Path makePathAbsolute(String file) throws IOException {
        return Paths.get(this.makePathAbsolute(file, false), new String[0]);
    }

    public String makePathAbsolute(String href, boolean allowURL) throws IOException {
        try {
            if (allowURL) {
                return new URL(href).toExternalForm();
            }
            new URL(href);
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "You can only use local file system pathes instead of '%s'.", href));
        }
        catch (MalformedURLException me) {
            Path f = Paths.get(href, new String[0]);
            if (f.isAbsolute()) {
                return f.toRealPath(new LinkOption[0]).toString();
            }
            return this.file.resolveSibling(href).toRealPath(new LinkOption[0]).toString();
        }
    }

    public void addField(FieldConfig f) {
        if (f.name == null) {
            throw new IllegalArgumentException("A field name is mandatory");
        }
        if (this.fields.containsKey(f.name)) {
            throw new IllegalArgumentException("A field with name '" + f.name + "' already exists!");
        }
        if (f.xPathExpr == null && f.xslt == null) {
            throw new IllegalArgumentException("A XPath or template itsself may not be empty");
        }
        if (f.xPathExpr != null && f.xslt != null) {
            throw new IllegalArgumentException("It may not both XPath and template be defined");
        }
        if (f.datatype == FieldConfig.DataType.XHTML && f.xslt == null) {
            throw new IllegalArgumentException("XHTML fields may only be declared as a XSLT template (using <field-template/>)");
        }
        if (f.defaultValue != null && f.datatype != FieldConfig.DataType.NUMBER && f.datatype != FieldConfig.DataType.INTEGER && f.datatype != FieldConfig.DataType.DATETIME) {
            throw new IllegalArgumentException("A default value can only be given for NUMBER, INTEGER, BOOLEAN, or DATETIME fields");
        }
        this.fields.put(f.name, f);
    }

    public void addVariable(VariableConfig f) {
        if (this.filters.size() > 0 || this.fields.size() > 0) {
            throw new IllegalStateException("Variables must be declared before all fields and filters!");
        }
        if (f.name == null) {
            throw new IllegalArgumentException("A variable name is mandatory");
        }
        if (XPathResolverImpl.DOCUMENT_PROCESSOR_NAMESPACE.equals(f.name.getNamespaceURI())) {
            throw new IllegalArgumentException("A XPath variable name may not be in the namespace for internal variables ('" + XPathResolverImpl.DOCUMENT_PROCESSOR_NAMESPACE + "')");
        }
        if (f.xPathExpr == null && f.xslt == null) {
            throw new IllegalArgumentException("A XPath or template itsself may not be empty");
        }
        if (f.xPathExpr != null && f.xslt != null) {
            throw new IllegalArgumentException("It may not both XPath and template be defined");
        }
        this.xPathVariables.add(f);
    }

    public void addFilter(FilterConfig f) {
        if (f.xPathExpr == null) {
            throw new IllegalArgumentException("A filter needs an XPath expression");
        }
        if (f.xslt != null) {
            throw new IllegalArgumentException("A filter may not contain a template");
        }
        f.type = FilterConfig.FilterType.valueOf(this.dig.getCurrentElementName().toUpperCase(Locale.ROOT));
        this.filters.add(f);
    }

    public void addTargetIndex(TargetIndexConfig tic) {
        if (!this.harvestersAndIndexes.add(tic.indexName)) {
            throw new IllegalArgumentException("There is already a harvester or targetIndex with id=\"" + tic.indexName + "\" added to configuration!");
        }
        this.targetIndexes.put(tic.indexName, tic);
    }

    @PublicForDigesterUse
    @Deprecated
    public void setXMLField(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name for XML field: " + name);
        }
        this.fieldnameXML = name;
    }

    @PublicForDigesterUse
    @Deprecated
    public void setDatestampField(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name for datestamp field: " + name);
        }
        this.fieldnameDatestamp = name;
    }

    @PublicForDigesterUse
    @Deprecated
    public void setSourceField(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid name for source field: " + name);
        }
        this.fieldnameSource = name;
    }

    @PublicForDigesterUse
    @Deprecated
    public void setFilterDefault(String v) {
        if (v == null) {
            return;
        }
        FilterConfig f = new FilterConfig();
        f.setType(v);
        this.filterDefault = f.type;
    }

    public void setSchema(String namespace, String url) throws Exception {
        if (this.schema != null) {
            throw new SAXException("Schema URL already defined!");
        }
        url = this.makePathAbsolute(url.trim(), true);
        if (namespace != null) {
            namespace = namespace.trim();
        }
        if (namespace == null || "".equals(namespace)) {
            namespace = "http://www.w3.org/2001/XMLSchema";
        }
        log.info((Object)("Loading XML schema in format '" + namespace + "' from URL '" + url + "'..."));
        try {
            SchemaFactory fact = SchemaFactory.newInstance(namespace);
            this.schema = fact.newSchema(new StreamSource(url));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Your XML installation does not support schemas in format '" + namespace + "'!");
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setTypeName(String v) {
        this.typeName = v;
    }

    @PublicForDigesterUse
    @Deprecated
    public void setEsMappingFile(String v) throws IOException {
        if (this.esMappingFile != null) {
            throw new IllegalArgumentException("Duplicate Elasticsearch mapping file");
        }
        this.esMappingFile = this.makePathAbsolute(v);
        try (BufferedReader reader = Files.newBufferedReader(this.esMappingFile, StandardCharsets.UTF_8);){
            this.esMapping = Streams.copyToString((Reader)reader);
        }
    }

    @PublicForDigesterUse
    @Deprecated
    public void setHaltOnSchemaError(String v) {
        this.haltOnSchemaError = BooleanParser.parseBoolean(v.trim());
    }

    @PublicForDigesterUse
    @Deprecated
    public void setAugmentation(String v) {
        this.validateWithAugmentation = BooleanParser.parseBoolean(v.trim());
    }

    @PublicForDigesterUse
    @Deprecated
    public void addEsAddress(String v) {
        this.esTransports.add(new InetSocketTransportAddress(HostAndPort.parse(v.trim(), 9300)));
    }

    @PublicForDigesterUse
    @Deprecated
    public void setEsSettings(Settings.Builder bld) {
        if (this.esSettings != null) {
            throw new IllegalArgumentException("Duplicate elasticsearchCluster/settings element");
        }
        this.esSettings = bld.build();
    }

    Templates loadTemplate(String file) throws Exception {
        Templates templ = this.templatesCache.get(file = this.makePathAbsolute(file, true));
        if (templ == null) {
            log.info((Object)("Loading XSL transformation from '" + file + "'..."));
            templ = StaticFactories.transFactory.newTemplates(new StreamSource(file));
            this.templatesCache.put(file, templ);
        }
        return templ;
    }
}

