/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.utils;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public final class KeyValuePairs {
    private final Map<String, Object[]> map = new LinkedHashMap<String, Object[]>();

    public void add(String key, Object value) {
        Object[] existingVals = this.map.get(key);
        if (existingVals == null) {
            this.map.put(key, new Object[]{value});
        } else {
            Object[] newVals = new Object[existingVals.length + 1];
            System.arraycopy(existingVals, 0, newVals, 0, existingVals.length);
            newVals[existingVals.length] = value;
            this.map.put(key, newVals);
        }
    }

    public void add(String key, Object ... values) {
        if (values.length == 0) {
            return;
        }
        Object[] existingVals = this.map.get(key);
        if (existingVals == null) {
            this.map.put(key, values);
        } else {
            Object[] newVals = new Object[existingVals.length + values.length];
            System.arraycopy(existingVals, 0, newVals, 0, existingVals.length);
            System.arraycopy(values, 0, newVals, existingVals.length, values.length);
            this.map.put(key, newVals);
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private void serializeValue(XContentBuilder builder, Object o) throws IOException {
        if (o instanceof KeyValuePairs) {
            ((KeyValuePairs)o).serializeToContentBuilder(builder);
        } else {
            builder.value(o);
        }
    }

    public void serializeToContentBuilder(XContentBuilder builder) throws IOException {
        if (this.map.isEmpty()) {
            builder.nullValue();
        } else {
            builder.startObject();
            block4: for (Map.Entry<String, Object[]> e : this.map.entrySet()) {
                Object[] val = e.getValue();
                switch (val.length) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        builder.field(e.getKey());
                        this.serializeValue(builder, val[0]);
                        continue block4;
                    }
                }
                builder.startArray(e.getKey());
                for (Object o : val) {
                    this.serializeValue(builder, o);
                }
                builder.endArray();
            }
            builder.endObject();
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            this.serializeToContentBuilder(builder);
            return builder.string();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }
}

