/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.config.TargetIndexConfig;
import de.pangaea.metadataportal.harvester.Rebuilder;
import de.pangaea.metadataportal.processor.DocumentProcessor;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.processor.MetadataDocument;
import de.pangaea.metadataportal.utils.ISODateFormatter;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXParseException;

public abstract class Harvester {
    private static final Log staticLog = LogFactory.getLog(Harvester.class);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected DocumentProcessor processor = null;
    protected final HarvesterConfig iconfig;
    protected int harvestCount = 0;
    protected final int harvestMessageStep;
    protected Instant fromDateReference = null;
    private Instant harvestingDateReference = null;
    private Set<String> validIdentifiers = null;
    public static final String HARVESTER_METADATA_FIELD_LAST_HARVESTED = "lastHarvested";

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Command line: java " + Harvester.class.getName() + " config.xml [harvester-name|*]");
            return;
        }
        try {
            Config conf = new Config(args[0]);
            Harvester.runHarvester(conf, args.length == 2 ? args[1] : null);
        }
        catch (Exception e) {
            staticLog.fatal((Object)"Harvester general error:", (Throwable)e);
        }
    }

    public static boolean runHarvester(Config conf, String harvesterId) {
        return Harvester.runHarvester(conf, harvesterId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean runHarvester(Config conf, String id, Class<? extends Harvester> harvesterClass) {
        Set<String> activeIds;
        if (Harvester.isAllIndexes(id)) {
            activeIds = conf.targetIndexes.keySet();
        } else {
            if (!conf.harvestersAndIndexes.contains(id)) {
                throw new IllegalArgumentException("There is no harvester or targetIndex defined with id=\"" + id + "\"!");
            }
            activeIds = Collections.singleton(id);
        }
        if (Collections.disjoint(activeIds, conf.harvestersAndIndexes)) {
            staticLog.warn((Object)"No sources to harvest.");
            return false;
        }
        try (ElasticsearchConnection es = new ElasticsearchConnection(conf);){
            boolean anyUpdate = false;
            for (TargetIndexConfig ticonf : conf.targetIndexes.values()) {
                if (!activeIds.contains(ticonf.indexName) && Collections.disjoint(activeIds, ticonf.harvesters.keySet())) continue;
                boolean isRebuilder = harvesterClass == Rebuilder.class;
                String targetIndex = es.createIndex(ticonf, isRebuilder);
                boolean globalCleanShutdown = true;
                for (HarvesterConfig harvesterConf : ticonf.harvesters.values()) {
                    if (!activeIds.contains(ticonf.indexName) && !activeIds.contains(harvesterConf.id)) continue;
                    Class<? extends Harvester> hc = harvesterClass == null ? harvesterConf.harvesterClass : harvesterClass;
                    staticLog.info((Object)("Harvesting documents from \"" + harvesterConf.id + "\" using harvester class \"" + hc.getName() + "\"..."));
                    Harvester h = null;
                    boolean cleanShutdown = false;
                    try {
                        try {
                            h = hc.getConstructor(HarvesterConfig.class).newInstance(harvesterConf);
                            h.open(es, targetIndex);
                            h.harvest();
                            cleanShutdown = true;
                        }
                        catch (Exception e) {
                            Harvester.logExceptions(e, harvesterConf);
                        }
                        if (h == null || h.isClosed()) continue;
                        try {
                            h.close(cleanShutdown);
                            staticLog.info((Object)("Harvester \"" + harvesterConf.id + "\" closed."));
                        }
                        catch (Exception e) {
                            staticLog.fatal((Object)("Error during harvesting from \"" + harvesterConf.id + "\" occurred:"), (Throwable)e);
                        }
                    }
                    finally {
                        globalCleanShutdown &= cleanShutdown;
                    }
                }
                es.closeIndex(ticonf, targetIndex, globalCleanShutdown);
                anyUpdate |= globalCleanShutdown;
            }
            boolean bl = anyUpdate;
            return bl;
        }
    }

    private static void logExceptions(Throwable e, HarvesterConfig harvesterConf) {
        if (e instanceof SAXParseException) {
            SAXParseException saxe = (SAXParseException)e;
            staticLog.fatal((Object)("Harvesting documents from \"" + harvesterConf.id + "\" failed due to SAX parse error in \"" + saxe.getSystemId() + "\", line " + saxe.getLineNumber() + ", column " + saxe.getColumnNumber() + ":"), (Throwable)saxe);
        } else if (e instanceof TransformerException) {
            TransformerException transfe = (TransformerException)e;
            String loc = transfe.getLocationAsString();
            staticLog.fatal((Object)("Harvesting documents from \"" + harvesterConf.id + "\" failed due to transformer/parse error" + (String)(loc != null ? " at " + loc : "") + ":"), (Throwable)transfe);
        } else if (e instanceof InvocationTargetException && e.getCause() != null) {
            Harvester.logExceptions(e.getCause(), harvesterConf);
        } else {
            staticLog.fatal((Object)("Harvesting documents from \"" + harvesterConf.id + "\" failed!"), e);
        }
    }

    protected static boolean isAllIndexes(String id) {
        return id == null || "*".equals(id) || "all".equals(id);
    }

    public Harvester(HarvesterConfig iconfig) {
        if (iconfig == null) {
            throw new IllegalArgumentException("Missing harvester configuration");
        }
        this.iconfig = iconfig;
        this.harvestMessageStep = Integer.parseInt(iconfig.properties.getProperty("harvestMessageStep", "100"));
        if (this.harvestMessageStep <= 0) {
            throw new IllegalArgumentException("Invalid value for harvestMessageStep: " + this.harvestMessageStep);
        }
    }

    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        this.processor = es.getDocumentProcessor(this.iconfig, targetIndex);
        String v = this.processor.harvesterMetadata.get(HARVESTER_METADATA_FIELD_LAST_HARVESTED);
        this.fromDateReference = v != null ? Instant.parse(v.toString()) : null;
    }

    public void prepareReindex(ElasticsearchConnection es, String targetIndex) throws Exception {
    }

    public void finishReindex(boolean cleanShutdown) throws Exception {
    }

    public boolean isClosed() {
        return this.processor == null;
    }

    public void close(boolean cleanShutdown) throws Exception {
        if (this.processor == null) {
            throw new IllegalStateException("Harvester must be opened before closing");
        }
        if (cleanShutdown && this.harvestingDateReference != null) {
            this.processor.harvesterMetadata.put(HARVESTER_METADATA_FIELD_LAST_HARVESTED, ISODateFormatter.formatElasticsearch(this.harvestingDateReference));
        }
        this.harvestingDateReference = null;
        if (!this.processor.isClosed()) {
            this.processor.close(cleanShutdown ? this.validIdentifiers : null);
        }
        this.processor = null;
        this.validIdentifiers = null;
        if (cleanShutdown) {
            this.log.info((Object)("Harvested " + this.harvestCount + " objects - finished."));
        } else {
            this.log.warn((Object)("Harvesting stopped unexspected, but " + this.harvestCount + " objects harvested - finished."));
        }
    }

    public MetadataDocument createMetadataDocumentInstance() {
        return new MetadataDocument(this.iconfig);
    }

    protected void addDocument(MetadataDocument mdoc) throws Exception {
        if (this.processor == null) {
            throw new IllegalStateException("Harvester must be opened before using");
        }
        this.processor.addDocument(mdoc);
        ++this.harvestCount;
        if (this.harvestCount % this.harvestMessageStep == 0) {
            this.log.info((Object)("Harvested " + this.harvestCount + " objects so far."));
        }
    }

    protected void deleteDocument(String identifier) throws Exception {
        MetadataDocument mdoc = this.createMetadataDocumentInstance();
        mdoc.setIdentifier(identifier);
        mdoc.setDeleted(true);
        this.addDocument(mdoc);
    }

    protected boolean isDocumentOutdated(Instant lastModified) {
        return this.fromDateReference == null || lastModified == null || this.fromDateReference.isBefore(lastModified);
    }

    protected void setHarvestingDateReference(Instant harvestingDateReference) {
        this.harvestingDateReference = harvestingDateReference;
    }

    protected void setValidIdentifiers(Set<String> validIdentifiers) {
        this.validIdentifiers = validIdentifiers;
    }

    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        props.addAll(Arrays.asList("harvestMessageStep", "bulkSize", "deleteUnseenBulkSize", "numThreads", "maxQueue", "maxBulkMemory", "sourceContentType", "concurrentBulkRequests", "conversionErrorAction", "validate"));
    }

    public final Set<String> getValidHarvesterPropertyNames() {
        TreeSet<String> props = new TreeSet<String>();
        this.enumerateValidHarvesterPropertyNames(props);
        return Collections.unmodifiableSet(props);
    }

    public abstract void harvest() throws Exception;
}

