/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.Harvester;
import de.pangaea.metadataportal.processor.DocumentErrorAction;
import de.pangaea.metadataportal.processor.MetadataDocument;
import de.pangaea.metadataportal.utils.BooleanParser;
import de.pangaea.metadataportal.utils.HugeStringHashBuilder;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXParseException;

public abstract class SingleFileEntitiesHarvester
extends Harvester {
    private final DocumentErrorAction parseErrorAction;
    private HugeStringHashBuilder validIdentifiersBuilder = null;
    private Instant newestDatestamp = null;

    public SingleFileEntitiesHarvester(HarvesterConfig iconfig) {
        this(iconfig, SingleFileEntitiesHarvester.parseDocumentErrorAction(iconfig));
    }

    protected SingleFileEntitiesHarvester(HarvesterConfig iconfig, DocumentErrorAction parseErrorAction) {
        super(iconfig);
        this.parseErrorAction = parseErrorAction;
        if (BooleanParser.parseBoolean(iconfig.properties.getProperty("deleteMissingDocuments", "true"))) {
            this.validIdentifiersBuilder = new HugeStringHashBuilder();
        }
    }

    private static DocumentErrorAction parseDocumentErrorAction(HarvesterConfig iconfig) {
        String s = iconfig.properties.getProperty("parseErrorAction", DocumentErrorAction.IGNOREDOCUMENT.name());
        try {
            return DocumentErrorAction.valueOf(s.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value '" + s + "' for harvester property 'parseErrorAction', valid ones are: " + Arrays.toString((Object[])DocumentErrorAction.values()));
        }
    }

    @Override
    public void close(boolean cleanShutdown) throws Exception {
        if (cleanShutdown && this.validIdentifiersBuilder != null) {
            this.setValidIdentifiers(this.validIdentifiersBuilder.build());
        }
        super.close(cleanShutdown);
    }

    protected final void addDocument(String identifier, long lastModified, Source xml) throws Exception {
        this.addDocument(identifier, lastModified < 0L ? null : Instant.ofEpochMilli(lastModified), xml);
    }

    protected void addDocument(String identifier, Instant lastModified, Source xml) throws Exception {
        if (this.validIdentifiersBuilder != null) {
            this.validIdentifiersBuilder.add(identifier);
        }
        if (lastModified != null) {
            if (this.newestDatestamp == null || this.newestDatestamp.isBefore(lastModified)) {
                this.newestDatestamp = lastModified;
                this.setHarvestingDateReference(this.newestDatestamp);
            }
            if (!this.isDocumentOutdated(lastModified)) {
                return;
            }
        }
        if (xml == null) {
            return;
        }
        MetadataDocument mdoc = this.createMetadataDocumentInstance();
        mdoc.setIdentifier(identifier);
        mdoc.setDatestamp(lastModified);
        Exception e = null;
        String errstr = null;
        try {
            mdoc.getConverter().transform(xml);
        }
        catch (SAXParseException saxe) {
            e = saxe;
            errstr = "Harvesting object '" + identifier + "' failed due to SAX parse error in \"" + saxe.getSystemId() + "\", line " + saxe.getLineNumber() + ", column " + saxe.getColumnNumber();
        }
        catch (TransformerException transfe) {
            e = transfe;
            String loc = transfe.getLocationAsString();
            errstr = "Harvesting object '" + identifier + "' failed due to transformer/parse error" + (String)(loc != null ? " at " + loc : "");
        }
        if (e != null && errstr != null) {
            switch (this.parseErrorAction) {
                case IGNOREDOCUMENT: {
                    this.log.error((Object)(errstr + " (object ignored):"), (Throwable)e);
                    return;
                }
                case DELETEDOCUMENT: {
                    this.log.error((Object)(errstr + " (object marked deleted):"), (Throwable)e);
                    mdoc.setFinalDOM(null);
                    mdoc.setDeleted(true);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        this.addDocument(mdoc);
    }

    protected void cancelMissingDocumentDelete() {
        this.validIdentifiersBuilder = null;
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.addAll(Arrays.asList("parseErrorAction", "deleteMissingDocuments"));
    }
}

