/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.processor;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.processor.BackgroundFailure;
import de.pangaea.metadataportal.processor.DocumentErrorAction;
import de.pangaea.metadataportal.processor.MetadataDocument;
import de.pangaea.metadataportal.utils.KeyValuePairs;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

public final class DocumentProcessor {
    static final Log log = LogFactory.getLog(DocumentProcessor.class);
    private final HarvesterConfig iconfig;
    private final Client client;
    private final String targetIndex;
    private final String sourceIndex;
    private final int threadCount;
    private volatile boolean isClosed = false;
    public final Map<String, String> harvesterMetadata = new LinkedHashMap<String, String>();
    final AtomicReference<Throwable> failure = new AtomicReference<Object>(null);
    final AtomicInteger processed = new AtomicInteger(0);
    private final int bulkSize;
    private final int maxQueue;
    private final int concurrentBulkRequests;
    private final ByteSizeValue maxBulkMemory;
    private final DocumentErrorAction conversionErrorAction;
    private final XContentType contentType;
    private final Object poolInitLock = new Object();
    private ExecutorService pool = null;
    private volatile BulkProcessor bulkProcessor = null;
    public static final String HARVESTER_METADATA_TYPE = "panfmp_meta";
    public static final int DEFAULT_BULK_SIZE = 100;
    public static final ByteSizeValue DEFAULT_BULK_MEMORY = new ByteSizeValue(5L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_QUEUE = 100;
    public static final int DEFAULT_CONCURRENT_BULK_REQUESTS = 1;
    public static final int DEFAULT_NUM_THREADS = 1;
    public static final int DEFAULT_DELETE_UNSEEN_BULK_SIZE = 10000;
    public static final XContentType DEFAULT_CONTENT_TYPE = XContentType.CBOR;

    DocumentProcessor(Client client, HarvesterConfig iconfig, String targetIndex) {
        Map map;
        this.client = client;
        this.iconfig = iconfig;
        this.sourceIndex = iconfig.parent.indexName;
        this.targetIndex = targetIndex == null ? this.sourceIndex : targetIndex;
        this.bulkSize = Integer.parseInt(iconfig.properties.getProperty("bulkSize", Integer.toString(100)));
        String sz = iconfig.properties.getProperty("maxBulkMemory");
        this.maxBulkMemory = sz == null ? DEFAULT_BULK_MEMORY : ByteSizeValue.parseBytesSizeValue((String)sz, (String)"panfmp.maxBulkMemory");
        String ct = iconfig.properties.getProperty("sourceContentType");
        if (ct != null) {
            this.contentType = XContentType.fromMediaTypeOrFormat((String)ct);
            if (this.contentType == null) {
                throw new IllegalArgumentException("Illegal content type for _source field (sourceContentType property): " + ct);
            }
        } else {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        String s = iconfig.properties.getProperty("conversionErrorAction", "STOP");
        try {
            this.conversionErrorAction = DocumentErrorAction.valueOf(s.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value '" + s + "' for harvester property 'conversionErrorAction', valid ones are: " + Arrays.toString((Object[])DocumentErrorAction.values()));
        }
        this.concurrentBulkRequests = Integer.parseInt(iconfig.properties.getProperty("concurrentBulkRequests", Integer.toString(1)));
        this.threadCount = Integer.parseInt(iconfig.properties.getProperty("numThreads", Integer.toString(1)));
        if (this.threadCount < 1) {
            throw new IllegalArgumentException("numThreads harvester-property must be >=1!");
        }
        this.maxQueue = Integer.parseInt(iconfig.properties.getProperty("maxQueue", Integer.toString(100)));
        if (this.maxQueue < this.threadCount) {
            throw new IllegalArgumentException("maxQueue must be >=numThreads!");
        }
        GetResponse resp = (GetResponse)client.prepareGet(this.sourceIndex, HARVESTER_METADATA_TYPE, iconfig.id).setFetchSource(true).get();
        if (resp.isExists() && (map = resp.getSourceAsMap()) != null) {
            for (Map.Entry e : map.entrySet()) {
                this.harvesterMetadata.put((String)e.getKey(), e.getValue().toString());
            }
        }
    }

    public boolean isFailed() {
        return this.failure.get() != null;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Set<String> validIdentifiers) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("DocumentProcessor already closed");
        }
        this.isClosed = true;
        Object object = this.poolInitLock;
        synchronized (object) {
            if (this.pool != null) {
                log.info((Object)"Waiting for document processor to finish...");
                this.pool.shutdown();
                while (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn((Object)"Still waiting for document processor threadpool to finish...");
                }
                this.pool = null;
                log.info((Object)"Document processor to terminated.");
                log.info((Object)"Waiting for Elasticsearch bulk processor to finish...");
                this.bulkProcessor.awaitClose(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                this.bulkProcessor = null;
                log.info((Object)"Elasticsearch bulk processor terminated.");
                this.throwFailure();
                log.info((Object)(String.valueOf(this.processed) + " metadata items processed - finished."));
            }
        }
        this.throwFailure();
        if (validIdentifiers != null) {
            this.deleteUnseenDocuments(validIdentifiers);
        }
        log.info((Object)"Saving harvester metadata...");
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)this.contentType).map(this.harvesterMetadata);
        this.client.prepareIndex(this.targetIndex, HARVESTER_METADATA_TYPE, this.iconfig.id).setSource(builder).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(MetadataDocument mdoc) throws BackgroundFailure {
        if (this.isClosed()) {
            throw new IllegalStateException("DocumentProcessor already closed");
        }
        this.throwFailure();
        Object object = this.poolInitLock;
        synchronized (object) {
            this.startPool();
            this.pool.execute(this.getRunnable(mdoc));
        }
        this.throwFailure();
    }

    private void deleteUnseenDocuments(Set<String> validIdentifiers) {
        log.info((Object)"Removing metadata items not seen while harvesting...");
        long deleted = 0L;
        if (validIdentifiers.size() <= 10000) {
            IdsQueryBuilder bld = QueryBuilders.idsQuery((String[])new String[]{this.iconfig.root.typeName});
            bld.ids().addAll(validIdentifiers);
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)this.iconfig.root.fieldnameSource, (String)this.iconfig.id)).mustNot((QueryBuilder)bld);
            BulkByScrollResponse response = (BulkByScrollResponse)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)DeleteByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.client).filter((QueryBuilder)query)).source(new String[]{this.targetIndex})).get();
            deleted += response.getDeleted();
        } else {
            TimeValue time = TimeValue.timeValueMinutes((long)10L);
            SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(new String[]{this.targetIndex}).setTypes(new String[]{this.iconfig.root.typeName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)this.iconfig.root.fieldnameSource, (String)this.iconfig.id)).setFetchSource(false).setSize(10000).addSort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).setScroll(time).get();
            do {
                BulkRequestBuilder bulk = this.client.prepareBulk();
                for (SearchHit hit : scrollResp.getHits()) {
                    String id = hit.getId();
                    if (validIdentifiers.contains(id)) continue;
                    bulk.add(new DeleteRequest(this.targetIndex, this.iconfig.root.typeName, id));
                }
                if (bulk.numberOfActions() <= 0) continue;
                BulkResponse bulkResp = (BulkResponse)bulk.get();
                for (BulkItemResponse resp : bulkResp) {
                    DeleteResponse delResp = (DeleteResponse)resp.getResponse();
                    if (delResp.getResult() != DocWriteResponse.Result.DELETED) {
                        log.warn((Object)("Metadata item with ID '" + delResp.getId() + "' was not found when we tried to delete it."));
                        continue;
                    }
                    ++deleted;
                }
            } while (scrollResp.getScrollId() != null && (scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(time).get()).getHits().getHits().length > 0);
        }
        log.info((Object)("Deleted a total number of " + deleted + " metadata items."));
    }

    private Runnable getRunnable(MetadataDocument mdoc) {
        return () -> {
            block4: {
                if (this.failure.get() != null) {
                    return;
                }
                try {
                    DocWriteRequest<?> req = this.buildDocumentAction(mdoc);
                    if (req != null) {
                        this.bulkProcessor.add(req);
                    }
                }
                catch (Throwable e) {
                    if (this.failure.compareAndSet(null, e)) break block4;
                    log.error((Object)e);
                }
            }
        };
    }

    public DocWriteRequest<?> buildDocumentAction(MetadataDocument mdoc) throws Exception {
        String identifier = mdoc.getIdentifier();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converting document: " + mdoc.toString()));
        }
        KeyValuePairs kv = null;
        try {
            kv = mdoc.getKeyValuePairs();
        }
        catch (Exception e) {
            switch (this.conversionErrorAction) {
                case IGNOREDOCUMENT: {
                    log.error((Object)String.format(Locale.ENGLISH, "Conversion XML to Elasticsearch document failed for '%s' (object ignored):", identifier), (Throwable)e);
                    return null;
                }
                case DELETEDOCUMENT: {
                    log.error((Object)String.format(Locale.ENGLISH, "Conversion XML to Elasticsearch document failed for '%s' (object marked deleted):", identifier), (Throwable)e);
                    kv = null;
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (kv == null || kv.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting document: " + identifier));
            }
            return new DeleteRequest(this.targetIndex, this.iconfig.root.typeName, identifier);
        }
        XContentBuilder source = XContentFactory.contentBuilder((XContentType)this.contentType);
        kv.serializeToContentBuilder(source);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating document: " + identifier));
        }
        return new IndexRequest(this.targetIndex, this.iconfig.root.typeName, identifier).source(source);
    }

    private void throwFailure() throws BackgroundFailure {
        Throwable f = this.failure.get();
        if (f != null) {
            throw new BackgroundFailure(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPool() {
        Object object = this.poolInitLock;
        synchronized (object) {
            if (this.pool == null) {
                assert (this.bulkProcessor == null);
                this.bulkProcessor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

                    public void beforeBulk(long executionId, BulkRequest request) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format(Locale.ENGLISH, "Sending bulk with %d actions to Elasticsearch...", request.numberOfActions()));
                        }
                    }

                    public void afterBulk(long executionId, BulkRequest request, Throwable f) {
                        if (f instanceof Exception) {
                            if (!DocumentProcessor.this.failure.compareAndSet(null, (Exception)f)) {
                                log.error((Object)"Exception happened while doing bulk request.", f);
                            }
                        } else {
                            if (f instanceof Error) {
                                throw (Error)f;
                            }
                            throw new AssertionError((Object)f);
                        }
                    }

                    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                        if (response.hasFailures()) {
                            this.afterBulk(executionId, request, (Throwable)new ElasticsearchException("Error while executing bulk request: " + response.buildFailureMessage(), new Object[0]));
                            return;
                        }
                        int totalItems = DocumentProcessor.this.processed.addAndGet(request.numberOfActions());
                        log.info((Object)(totalItems + " metadata items processed so far."));
                    }
                }).setConcurrentRequests(this.concurrentBulkRequests).setBulkActions(this.bulkSize).setBulkSize(this.maxBulkMemory).build();
                this.pool = new ThreadPoolExecutor(this.threadCount, this.threadCount, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.maxQueue, false), new RejectedExecutionHandler(){

                    @Override
                    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                        if (e.isShutdown()) {
                            throw new RejectedExecutionException("Executor shutdown.");
                        }
                        r.run();
                    }
                });
            }
        }
    }
}

