/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.XGeoPointDistanceRangeQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.mapper.LatLonPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.search.geo.LegacyGeoDistanceRangeQuery;

public class GeoDistanceRangeQueryBuilder
extends AbstractQueryBuilder<GeoDistanceRangeQueryBuilder> {
    public static final String NAME = "geo_distance_range";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(GeoDistanceRangeQueryBuilder.class));
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final GeoDistance DEFAULT_GEO_DISTANCE = GeoDistance.ARC;
    public static final DistanceUnit DEFAULT_UNIT = DistanceUnit.DEFAULT;
    @Deprecated
    public static final String DEFAULT_OPTIMIZE_BBOX = "memory";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    private static final ParseField TO_FIELD = new ParseField("to", new String[0]);
    private static final ParseField INCLUDE_LOWER_FIELD = new ParseField("include_lower", new String[0]);
    private static final ParseField INCLUDE_UPPER_FIELD = new ParseField("include_upper", new String[0]);
    private static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
    private static final ParseField GTE_FIELD = new ParseField("gte", "ge");
    private static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    private static final ParseField LTE_FIELD = new ParseField("lte", "le");
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
    private static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    @Deprecated
    private static final ParseField OPTIMIZE_BBOX_FIELD = new ParseField("optimize_bbox", new String[0]).withAllDeprecated("no replacement: `optimize_bbox` is no longer supported due to recent improvements");
    private static final ParseField COERCE_FIELD = new ParseField("coerce", "normalize").withAllDeprecated("use validation_method instead");
    private static final ParseField IGNORE_MALFORMED_FIELD = new ParseField("ignore_malformed", new String[0]).withAllDeprecated("use validation_method instead");
    private static final ParseField VALIDATION_METHOD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private boolean ignoreUnmapped = false;
    private final GeoPoint point;
    private GeoDistance geoDistance = DEFAULT_GEO_DISTANCE;
    private DistanceUnit unit = DEFAULT_UNIT;
    private String optimizeBbox = null;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;

    public GeoDistanceRangeQueryBuilder(String fieldName, GeoPoint point) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        this.fieldName = fieldName;
        this.point = point;
    }

    public GeoDistanceRangeQueryBuilder(String fieldName, double lat, double lon) {
        this(fieldName, new GeoPoint(lat, lon));
    }

    public GeoDistanceRangeQueryBuilder(String fieldName, String geohash) {
        this(fieldName, geohash == null ? null : new GeoPoint().resetFromGeoHash(geohash));
    }

    public GeoDistanceRangeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.point = in.readGeoPoint();
        this.from = in.readGenericValue();
        this.to = in.readGenericValue();
        this.includeLower = in.readBoolean();
        this.includeUpper = in.readBoolean();
        this.unit = DistanceUnit.valueOf(in.readString());
        this.geoDistance = GeoDistance.readFromStream(in);
        this.optimizeBbox = in.readOptionalString();
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGeoPoint(this.point);
        out.writeGenericValue(this.from);
        out.writeGenericValue(this.to);
        out.writeBoolean(this.includeLower);
        out.writeBoolean(this.includeUpper);
        out.writeString(this.unit.name());
        this.geoDistance.writeTo(out);
        out.writeOptionalString(this.optimizeBbox);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoPoint point() {
        return this.point;
    }

    public GeoDistanceRangeQueryBuilder from(String from) {
        if (from == null) {
            throw new IllegalArgumentException("[from] must not be null");
        }
        this.from = from;
        return this;
    }

    public GeoDistanceRangeQueryBuilder from(Number from) {
        if (from == null) {
            throw new IllegalArgumentException("[from] must not be null");
        }
        this.from = from;
        return this;
    }

    public Object from() {
        return this.from;
    }

    public GeoDistanceRangeQueryBuilder to(String to) {
        if (to == null) {
            throw new IllegalArgumentException("[to] must not be null");
        }
        this.to = to;
        return this;
    }

    public GeoDistanceRangeQueryBuilder to(Number to) {
        if (to == null) {
            throw new IllegalArgumentException("[to] must not be null");
        }
        this.to = to;
        return this;
    }

    public Object to() {
        return this.to;
    }

    public GeoDistanceRangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public GeoDistanceRangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public GeoDistanceRangeQueryBuilder geoDistance(GeoDistance geoDistance) {
        if (geoDistance == null) {
            throw new IllegalArgumentException("geoDistance calculation mode must not be null");
        }
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public GeoDistanceRangeQueryBuilder unit(DistanceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("distance unit must not be null");
        }
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    @Deprecated
    public GeoDistanceRangeQueryBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    @Deprecated
    public String optimizeBbox() {
        return this.optimizeBbox;
    }

    public GeoDistanceRangeQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoDistanceRangeQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        boolean indexCreatedBeforeV2_0 = context.indexVersionCreated().before(Version.V_2_0_0);
        boolean indexCreatedBeforeV2_2 = context.indexVersionCreated().before(Version.V_2_2_0);
        if (!indexCreatedBeforeV2_0 && !GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            if (!GeoUtils.isValidLatitude(this.point.lat())) {
                throw new QueryShardException(context, "illegal latitude value [{}] for [{}]", this.point.lat(), NAME);
            }
            if (!GeoUtils.isValidLongitude(this.point.lon())) {
                throw new QueryShardException(context, "illegal longitude value [{}] for [{}]", this.point.lon(), NAME);
            }
        }
        GeoPoint point = new GeoPoint(this.point);
        if (!indexCreatedBeforeV2_2 || GeoValidationMethod.isCoerce(this.validationMethod)) {
            GeoUtils.normalizePoint(point, true, true);
        }
        Double fromValue = this.from != null ? (this.from instanceof Number ? Double.valueOf(this.unit.toMeters(((Number)this.from).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)this.from, this.unit, DistanceUnit.DEFAULT))) : Double.valueOf(0.0);
        Double toValue = this.to != null ? (this.to instanceof Number ? Double.valueOf(this.unit.toMeters(((Number)this.to).doubleValue())) : Double.valueOf(DistanceUnit.parse((String)this.to, this.unit, DistanceUnit.DEFAULT))) : Double.valueOf(GeoUtils.maxRadialDistanceMeters(point.lat(), point.lon()));
        Version indexVersionCreated = context.indexVersionCreated();
        if (indexVersionCreated.onOrAfter(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION)) {
            throw new QueryShardException(context, "[{}] queries are no longer supported for geo_point field types. Use geo_distance sort or aggregations", NAME);
        }
        deprecationLogger.deprecated("geo_distance_range search is deprecated. Use geo_distance aggregation or sort instead.", new Object[0]);
        if (indexVersionCreated.before(Version.V_2_2_0)) {
            IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)context.getForField(fieldType);
            return new LegacyGeoDistanceRangeQuery(point, fromValue, toValue, this.includeLower, this.includeUpper, this.geoDistance, (BaseGeoPointFieldMapper.LegacyGeoPointFieldType)fieldType, indexFieldData, this.optimizeBbox, context);
        }
        GeoPointField.TermEncoding encoding = indexVersionCreated.before(Version.V_2_3_0) ? GeoPointField.TermEncoding.NUMERIC : GeoPointField.TermEncoding.PREFIX;
        return new XGeoPointDistanceRangeQuery(fieldType.name(), encoding, point.lat(), point.lon(), this.includeLower ? fromValue : fromValue + 1.0E-6, this.includeUpper ? toValue : toValue - 1.0E-6);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(this.fieldName).value(this.point.lon()).value(this.point.lat()).endArray();
        builder.field(FROM_FIELD.getPreferredName(), this.from);
        builder.field(TO_FIELD.getPreferredName(), this.to);
        builder.field(INCLUDE_LOWER_FIELD.getPreferredName(), this.includeLower);
        builder.field(INCLUDE_UPPER_FIELD.getPreferredName(), this.includeUpper);
        builder.field(UNIT_FIELD.getPreferredName(), this.unit);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        if (!Strings.isEmpty(this.optimizeBbox)) {
            builder.field(OPTIMIZE_BBOX_FIELD.getPreferredName(), this.optimizeBbox);
        }
        builder.field(VALIDATION_METHOD.getPreferredName(), this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<GeoDistanceRangeQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Float boost = null;
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = null;
        String fieldName = null;
        Object vFrom = null;
        Object vTo = null;
        Boolean includeLower = null;
        Boolean includeUpper = null;
        DistanceUnit unit = null;
        GeoDistance geoDistance = null;
        String optimizeBbox = null;
        boolean coerce = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        boolean ignoreMalformed = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String maybeFieldName;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if (fieldName == null) {
                    if (point == null) {
                        point = new GeoPoint();
                    }
                    GeoUtils.parseGeoPoint(parser, point);
                    fieldName = currentFieldName;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[geo_distance_range] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName == null) {
                    fieldName = currentFieldName;
                    if (point == null) {
                        point = new GeoPoint();
                    }
                    GeoUtils.parseGeoPoint(parser, point);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[geo_distance_range] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (FROM_FIELD.match(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vFrom = parser.text();
                    continue;
                }
                vFrom = parser.numberValue();
                continue;
            }
            if (TO_FIELD.match(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NULL) continue;
                if (token == XContentParser.Token.VALUE_STRING) {
                    vTo = parser.text();
                    continue;
                }
                vTo = parser.numberValue();
                continue;
            }
            if (INCLUDE_LOWER_FIELD.match(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if (INCLUDE_UPPER_FIELD.match(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (GT_FIELD.match(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = false;
                continue;
            }
            if (GTE_FIELD.match(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vFrom = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeLower = true;
                continue;
            }
            if (LT_FIELD.match(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = false;
                continue;
            }
            if (LTE_FIELD.match(currentFieldName)) {
                if (token != XContentParser.Token.VALUE_NULL) {
                    vTo = token == XContentParser.Token.VALUE_STRING ? parser.text() : parser.numberValue();
                }
                includeUpper = true;
                continue;
            }
            if (UNIT_FIELD.match(currentFieldName)) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentFieldName)) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                maybeFieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                if (fieldName != null && !fieldName.equals(maybeFieldName)) {
                    throw new ParsingException(parser.getTokenLocation(), "[geo_distance_range] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = maybeFieldName;
                if (point == null) {
                    point = new GeoPoint();
                }
                point.resetLat(parser.doubleValue());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                maybeFieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                if (fieldName != null && !fieldName.equals(maybeFieldName)) {
                    throw new ParsingException(parser.getTokenLocation(), "[geo_distance_range] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = maybeFieldName;
                if (point == null) {
                    point = new GeoPoint();
                }
                point.resetLon(parser.doubleValue());
                continue;
            }
            if (NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if (BOOST_FIELD.match(currentFieldName)) {
                boost = Float.valueOf(parser.floatValue());
                continue;
            }
            if (OPTIMIZE_BBOX_FIELD.match(currentFieldName)) {
                optimizeBbox = parser.textOrNull();
                continue;
            }
            if (COERCE_FIELD.match(currentFieldName)) {
                coerce = parser.booleanValue();
                continue;
            }
            if (IGNORE_MALFORMED_FIELD.match(currentFieldName)) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            if (VALIDATION_METHOD.match(currentFieldName)) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (fieldName == null) {
                if (point == null) {
                    point = new GeoPoint();
                }
                point.resetFromString(parser.text());
                fieldName = currentFieldName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[geo_distance_range] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
        }
        GeoDistanceRangeQueryBuilder queryBuilder = new GeoDistanceRangeQueryBuilder(fieldName, point);
        if (boost != null) {
            queryBuilder.boost(boost.floatValue());
        }
        if (queryName != null) {
            queryBuilder.queryName(queryName);
        }
        if (vFrom != null) {
            if (vFrom instanceof Number) {
                queryBuilder.from((Number)vFrom);
            } else {
                queryBuilder.from((String)vFrom);
            }
        }
        if (vTo != null) {
            if (vTo instanceof Number) {
                queryBuilder.to((Number)vTo);
            } else {
                queryBuilder.to((String)vTo);
            }
        }
        if (includeUpper != null) {
            queryBuilder.includeUpper(includeUpper);
        }
        if (includeLower != null) {
            queryBuilder.includeLower(includeLower);
        }
        if (unit != null) {
            queryBuilder.unit(unit);
        }
        if (geoDistance != null) {
            queryBuilder.geoDistance(geoDistance);
        }
        if (optimizeBbox != null) {
            queryBuilder.optimizeBbox(optimizeBbox);
        }
        if (validationMethod != null) {
            queryBuilder.setValidationMethod(validationMethod);
        } else {
            queryBuilder.setValidationMethod(GeoValidationMethod.infer(coerce, ignoreMalformed));
        }
        queryBuilder.ignoreUnmapped(ignoreUnmapped);
        return Optional.of(queryBuilder);
    }

    @Override
    protected boolean doEquals(GeoDistanceRangeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.point, other.point) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.optimizeBbox, other.optimizeBbox) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.point, this.from, this.to, this.includeUpper, this.includeLower, this.geoDistance, this.optimizeBbox, this.validationMethod, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

