/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestClusterGetSettingsAction
extends BaseRestHandler {
    private final ClusterSettings clusterSettings;
    private final SettingsFilter settingsFilter;

    public RestClusterGetSettingsAction(Settings settings, RestController controller, ClusterSettings clusterSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.clusterSettings = clusterSettings;
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/settings", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest().routingTable(false).nodes(false);
        final boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestBuilderListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, RestClusterGetSettingsAction.renderResponse(response.getState(), renderDefaults, RestClusterGetSettingsAction.this.settingsFilter, RestClusterGetSettingsAction.this.clusterSettings, RestClusterGetSettingsAction.this.settings, builder, request));
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static XContentBuilder renderResponse(ClusterState state, boolean renderDefaults, SettingsFilter settingsFilter, ClusterSettings clusterSettings, Settings settings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        ClusterGetSettingsResponse response = new ClusterGetSettingsResponse(state, renderDefaults, settingsFilter, clusterSettings, settings);
        builder.startObject();
        builder.startObject("persistent");
        response.persistentSettings().toXContent(builder, params);
        builder.endObject();
        builder.startObject("transient");
        response.transientSettings().toXContent(builder, params);
        builder.endObject();
        if (renderDefaults) {
            builder.startObject("defaults");
            response.defaultSettings().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class ClusterGetSettingsResponse {
        private final Settings persistentSettings;
        private final Settings transientSettings;
        private final Settings defaultSettings;

        Settings persistentSettings() {
            return this.persistentSettings;
        }

        Settings transientSettings() {
            return this.transientSettings;
        }

        Settings defaultSettings() {
            return this.defaultSettings;
        }

        ClusterGetSettingsResponse(ClusterState state, boolean renderDefaults, SettingsFilter settingsFilter, ClusterSettings clusterSettings, Settings settings) {
            this.persistentSettings = settingsFilter.filter(state.metaData().persistentSettings());
            this.transientSettings = settingsFilter.filter(state.metaData().transientSettings());
            this.defaultSettings = renderDefaults ? settingsFilter.filter(clusterSettings.diff(state.metaData().settings(), settings)) : Settings.EMPTY;
        }
    }
}

