/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.config;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.utils.SaxRule;
import de.pangaea.metadataportal.utils.StaticFactories;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class TransformerSaxRule
extends SaxRule {
    protected final Config config;
    protected boolean hasBody = false;
    private TemplatesHandler th = null;

    TransformerSaxRule(Config config) {
        this.config = config;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.getContentHandler() == null) {
            String file = attributes.getValue("", "src");
            if (file != null) {
                this.setResult(this.config.loadTemplate(file));
                this.th = null;
                this.hasBody = false;
                this.setContentHandler(new DefaultHandler(){

                    @Override
                    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                        throw new SAXException("No element content allowed here. You can either include an XSL template directly into the config file or use the 'src' attribute!");
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        for (int i = 0; i < length; ++i) {
                            if (Character.isWhitespace(ch[start + i])) continue;
                            throw new SAXException("No element content allowed here. You can either include an XSL template directly into the config file or use the 'src' attribute!");
                        }
                    }
                });
            } else {
                this.th = StaticFactories.transFactory.newTemplatesHandler();
                this.th.setSystemId(this.config.file.toUri().toASCIIString());
                this.hasBody = true;
                this.setContentHandler(this.th);
            }
        } else {
            throw new SAXException("Invalid state of SAX parser, content handler already set: " + String.valueOf(this.getContentHandler()));
        }
        super.begin(namespace, name, attributes);
    }

    protected abstract void setResult(Templates var1);

    @Override
    public void end(String namespace, String name) throws Exception {
        super.end(namespace, name);
        if (this.th != null) {
            this.setResult(this.th.getTemplates());
        }
        this.th = null;
        this.setContentHandler(null);
        this.hasBody = false;
    }
}

