/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.harvester;

import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.SingleFileEntitiesHarvester;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.utils.BooleanParser;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DirectoryHarvester
extends SingleFileEntitiesHarvester {
    static final String WRAPPED_MARKER = "###wrapped###";
    final boolean recursive;
    final Pattern filenameFilter;
    final String identifierPrefix;
    Path directory = null;

    public DirectoryHarvester(HarvesterConfig iconfig) {
        super(iconfig);
        this.recursive = BooleanParser.parseBoolean(iconfig.properties.getProperty("recursive", "false"));
        this.identifierPrefix = iconfig.properties.getProperty("identifierPrefix", "");
        String s = iconfig.properties.getProperty("filenameFilter");
        this.filenameFilter = s == null ? null : Pattern.compile(s);
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        String directoryStr = this.iconfig.properties.getProperty("directory");
        if (directoryStr == null) {
            throw new IllegalArgumentException("Missing directory name to start harvesting (property \"directory\")");
        }
        this.directory = this.iconfig.root.makePathAbsolute(directoryStr);
    }

    @Override
    public void harvest() throws Exception {
        try {
            Files.walkFileTree(this.directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (DirectoryHarvester.this.recursive || dir.equals(DirectoryHarvester.this.directory)) {
                        StringBuilder logstr = new StringBuilder("Walking into directory \"").append(dir).append("\" (recursive=").append(DirectoryHarvester.this.recursive);
                        if (DirectoryHarvester.this.filenameFilter != null) {
                            logstr.append(",filter=\"").append(DirectoryHarvester.this.filenameFilter).append("\"");
                        }
                        logstr.append(")...");
                        DirectoryHarvester.this.log.info((Object)logstr);
                        return super.preVisitDirectory(dir, attrs);
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    DirectoryHarvester.this.log.info((Object)("Finished directory \"" + String.valueOf(dir) + "\"."));
                    return super.postVisitDirectory(dir, exc);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (DirectoryHarvester.this.filenameFilter.matcher(file.getFileName().toString()).matches()) {
                        try {
                            DirectoryHarvester.this.processFile(file);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(DirectoryHarvester.WRAPPED_MARKER, e);
                        }
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (RuntimeException e) {
            if (WRAPPED_MARKER.equals(e.getMessage())) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        super.enumerateValidHarvesterPropertyNames(props);
        props.addAll(Arrays.asList("directory", "recursive", "identifierPrefix", "filenameFilter"));
    }

    void processFile(Path file) throws Exception {
        URI relative = this.directory.toUri().relativize(file.toUri());
        String identifier = "file:" + this.identifierPrefix + relative.toASCIIString();
        this.addDocument(identifier, Files.getLastModifiedTime(file, new LinkOption[0]).toMillis(), (Source)new StreamSource(file.toUri().toASCIIString()));
    }
}

