/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.upgrade.get.IndexShardUpgradeStatus;
import org.elasticsearch.action.admin.indices.upgrade.get.IndexUpgradeStatus;
import org.elasticsearch.action.admin.indices.upgrade.get.ShardUpgradeStatus;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class UpgradeStatusResponse
extends BroadcastResponse
implements ToXContent {
    private ShardUpgradeStatus[] shards;
    private Map<String, IndexUpgradeStatus> indicesUpgradeStatus;

    UpgradeStatusResponse() {
    }

    UpgradeStatusResponse(ShardUpgradeStatus[] shards, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public Map<String, IndexUpgradeStatus> getIndices() {
        if (this.indicesUpgradeStatus != null) {
            return this.indicesUpgradeStatus;
        }
        HashMap<String, IndexUpgradeStatus> indicesUpgradeStats = new HashMap<String, IndexUpgradeStatus>();
        HashSet<String> indices = new HashSet<String>();
        for (ShardUpgradeStatus shard : this.shards) {
            indices.add(shard.getIndex());
        }
        for (String indexName : indices) {
            ArrayList<ShardUpgradeStatus> shards = new ArrayList<ShardUpgradeStatus>();
            for (ShardUpgradeStatus shard : this.shards) {
                if (!shard.getShardRouting().getIndexName().equals(indexName)) continue;
                shards.add(shard);
            }
            indicesUpgradeStats.put(indexName, new IndexUpgradeStatus(indexName, shards.toArray(new ShardUpgradeStatus[shards.size()])));
        }
        this.indicesUpgradeStatus = indicesUpgradeStats;
        return indicesUpgradeStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardUpgradeStatus[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ShardUpgradeStatus.readShardUpgradeStatus(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardUpgradeStatus shard : this.shards) {
            shard.writeTo(out);
        }
    }

    public long getTotalBytes() {
        long totalBytes = 0L;
        for (IndexUpgradeStatus indexShardUpgradeStatus : this.getIndices().values()) {
            totalBytes += indexShardUpgradeStatus.getTotalBytes();
        }
        return totalBytes;
    }

    public long getToUpgradeBytes() {
        long upgradeBytes = 0L;
        for (IndexUpgradeStatus indexShardUpgradeStatus : this.getIndices().values()) {
            upgradeBytes += indexShardUpgradeStatus.getToUpgradeBytes();
        }
        return upgradeBytes;
    }

    public long getToUpgradeBytesAncient() {
        long upgradeBytesAncient = 0L;
        for (IndexUpgradeStatus indexShardUpgradeStatus : this.getIndices().values()) {
            upgradeBytesAncient += indexShardUpgradeStatus.getToUpgradeBytesAncient();
        }
        return upgradeBytesAncient;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.byteSizeField("size_in_bytes", "size", this.getTotalBytes());
        builder.byteSizeField("size_to_upgrade_in_bytes", "size_to_upgrade", this.getToUpgradeBytes());
        builder.byteSizeField("size_to_upgrade_ancient_in_bytes", "size_to_upgrade_ancient", this.getToUpgradeBytesAncient());
        String level = params.param("level", "indices");
        boolean outputShards = "shards".equals(level);
        boolean bl = outputIndices = "indices".equals(level) || outputShards;
        if (outputIndices) {
            builder.startObject("indices");
            for (IndexUpgradeStatus indexUpgradeStatus : this.getIndices().values()) {
                builder.startObject(indexUpgradeStatus.getIndex());
                builder.byteSizeField("size_in_bytes", "size", indexUpgradeStatus.getTotalBytes());
                builder.byteSizeField("size_to_upgrade_in_bytes", "size_to_upgrade", indexUpgradeStatus.getToUpgradeBytes());
                builder.byteSizeField("size_to_upgrade_ancient_in_bytes", "size_to_upgrade_ancient", indexUpgradeStatus.getToUpgradeBytesAncient());
                if (outputShards) {
                    builder.startObject("shards");
                    for (IndexShardUpgradeStatus indexShardUpgradeStatus : indexUpgradeStatus) {
                        builder.startArray(Integer.toString(indexShardUpgradeStatus.getShardId().id()));
                        for (ShardUpgradeStatus shardUpgradeStatus : indexShardUpgradeStatus) {
                            builder.startObject();
                            builder.byteSizeField("size_in_bytes", "size", this.getTotalBytes());
                            builder.byteSizeField("size_to_upgrade_in_bytes", "size_to_upgrade", this.getToUpgradeBytes());
                            builder.byteSizeField("size_to_upgrade_ancient_in_bytes", "size_to_upgrade_ancient", this.getToUpgradeBytesAncient());
                            builder.startObject("routing");
                            builder.field("state", (Object)shardUpgradeStatus.getShardRouting().state());
                            builder.field("primary", shardUpgradeStatus.getShardRouting().primary());
                            builder.field("node", shardUpgradeStatus.getShardRouting().currentNodeId());
                            if (shardUpgradeStatus.getShardRouting().relocatingNodeId() != null) {
                                builder.field("relocating_node", shardUpgradeStatus.getShardRouting().relocatingNodeId());
                            }
                            builder.endObject();
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String SIZE_TO_UPGRADE = "size_to_upgrade";
        static final String SIZE_TO_UPGRADE_ANCIENT = "size_to_upgrade_ancient";
        static final String SIZE_TO_UPGRADE_IN_BYTES = "size_to_upgrade_in_bytes";
        static final String SIZE_TO_UPGRADE_ANCIENT_IN_BYTES = "size_to_upgrade_ancient_in_bytes";

        Fields() {
        }
    }
}

