/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryPrepareForTranslogOperationsRequest
extends TransportRequest {
    private long maxUnsafeAutoIdTimestamp = -1L;
    private long recoveryId;
    private ShardId shardId;
    private int totalTranslogOps = -1;

    public RecoveryPrepareForTranslogOperationsRequest() {
    }

    RecoveryPrepareForTranslogOperationsRequest(long recoveryId, ShardId shardId, int totalTranslogOps, long maxUnsafeAutoIdTimestamp) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.totalTranslogOps = totalTranslogOps;
        this.maxUnsafeAutoIdTimestamp = maxUnsafeAutoIdTimestamp;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.totalTranslogOps = in.readVInt();
        this.maxUnsafeAutoIdTimestamp = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        out.writeLong(this.maxUnsafeAutoIdTimestamp);
    }
}

