/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;

class GeoWorld
extends GeoBaseBBox {
    protected static final GeoPoint[] edgePoints = new GeoPoint[0];
    protected final GeoPoint originPoint;

    public GeoWorld(PlanetModel planetModel) {
        super(planetModel);
        this.originPoint = new GeoPoint(planetModel.ab, 1.0, 0.0, 0.0);
    }

    @Override
    public GeoBBox expand(double angle) {
        return this;
    }

    @Override
    public double getRadius() {
        return Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.originPoint;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return true;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (path.getEdgePoints().length > 0) {
            return 1;
        }
        return 2;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return 0.0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWorld)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GeoWorld: {planetmodel=" + this.planetModel + "}";
    }
}

