/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.processor;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.config.TargetIndexConfig;
import de.pangaea.metadataportal.processor.DocumentProcessor;
import de.pangaea.metadataportal.processor.MinimalTransportClient;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public final class ElasticsearchConnection
implements Closeable {
    private static final Log log = LogFactory.getLog(ElasticsearchConnection.class);
    private Client client;
    private final Config conf;
    public static final int ELASTICSEARCH_DEFAULT_PORT = 9300;
    private static final String HARVESTER_METADATA_MAPPING;

    public ElasticsearchConnection(Config config) {
        Settings settings = config.esSettings == null ? Settings.Builder.EMPTY_SETTINGS : config.esSettings;
        log.info((Object)("Connecting to Elasticsearch nodes: " + String.valueOf(config.esTransports)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("ES connection settings: " + String.valueOf(settings.getAsMap())));
        }
        this.conf = config;
        this.client = new MinimalTransportClient(settings, new Class[0]).addTransportAddresses(config.esTransports.toArray(new TransportAddress[config.esTransports.size()]));
    }

    @Override
    public void close() {
        this.client.close();
        this.client = null;
        log.info((Object)"Closed connection to Elasticsearch.");
    }

    private void checkOpen() {
        if (this.client == null) {
            throw new IllegalStateException("Elasticsearch TransportClient is already closed.");
        }
    }

    public Client client() {
        this.checkOpen();
        return this.client;
    }

    public DocumentProcessor getDocumentProcessor(HarvesterConfig iconfig, String targetIndex) {
        return new DocumentProcessor(this.client(), iconfig, targetIndex);
    }

    public void waitForYellow(TargetIndexConfig ticonf) {
        this.checkOpen();
        log.info((Object)("Waiting for index '" + ticonf.indexName + "' to get available..."));
        this.client.admin().cluster().prepareHealth(new String[]{ticonf.indexName}).setWaitForYellowStatus().get();
    }

    private String getAliasedIndex(TargetIndexConfig ticonf) {
        Iterator indexes = ((GetAliasesResponse)this.client.admin().indices().prepareGetAliases(new String[]{ticonf.indexName}).get()).getAliases().keysIt();
        String aliasedIndex = null;
        if (indexes.hasNext()) {
            aliasedIndex = (String)indexes.next();
            if (indexes.hasNext()) {
                throw new ElasticsearchException("There are more than one index referred by alias='" + ticonf.indexName + "'", new Object[0]);
            }
        }
        return aliasedIndex;
    }

    public String createIndex(TargetIndexConfig ticonf, boolean rebuilder) {
        String realIndexName;
        this.checkOpen();
        IndicesAdminClient indicesAdmin = this.client.admin().indices();
        log.info((Object)("Getting index name for alias='" + ticonf.indexName + "'..."));
        String aliasedIndex = this.getAliasedIndex(ticonf);
        if (aliasedIndex != null) {
            log.info((Object)("Alias exists and points to index='" + aliasedIndex + "'."));
            if (rebuilder) {
                realIndexName = ticonf.getRawIndexName(aliasedIndex.equals(ticonf.getRawIndexName(false)));
                log.info((Object)("As rebuilding is requested, we have to create a new index: " + realIndexName));
                DeleteIndexResponse resp = (DeleteIndexResponse)indicesAdmin.prepareDelete(new String[]{realIndexName}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).get();
                log.info((Object)("Pre-existing index deleted: " + resp.isAcknowledged()));
            } else {
                realIndexName = aliasedIndex;
            }
        } else {
            log.info((Object)"Alias does not yet exist, start fresh...");
            realIndexName = ticonf.getRawIndexName(false);
        }
        log.info((Object)("Creating index='" + realIndexName + "' and aliases..."));
        String mapping = this.getMapping();
        try {
            CreateIndexRequestBuilder req = indicesAdmin.prepareCreate(realIndexName).setCause(rebuilder ? "for rebuilding" : "new harvesting").addMapping("panfmp_meta", HARVESTER_METADATA_MAPPING, XContentType.JSON).addMapping(this.conf.typeName, mapping, XContentType.JSON);
            if (ticonf.indexSettings != null) {
                req.setSettings(ticonf.indexSettings);
            }
            if (!rebuilder) {
                req.addAlias(new Alias(ticonf.indexName));
                for (Map.Entry<String, String> e : ticonf.aliases.entrySet()) {
                    req.addAlias(new Alias(e.getKey()).filter(e.getValue()));
                }
            }
            CreateIndexResponse resp = (CreateIndexResponse)req.get();
            log.info((Object)("Index created and mappings assigned: " + resp.isAcknowledged()));
        }
        catch (ResourceAlreadyExistsException e) {
            log.info((Object)("Index already exists. Updating mappings for index='" + realIndexName + "'..."));
            PutMappingResponse resp = (PutMappingResponse)indicesAdmin.preparePutMapping(new String[]{realIndexName}).setType("panfmp_meta").setSource(HARVESTER_METADATA_MAPPING, XContentType.JSON).get();
            log.info((Object)("Harvester metadata mapping updated: " + resp.isAcknowledged()));
            resp = (PutMappingResponse)indicesAdmin.preparePutMapping(new String[]{realIndexName}).setType(this.conf.typeName).setSource(mapping, XContentType.JSON).get();
            log.info((Object)("XML metadata mapping updated: " + resp.isAcknowledged()));
        }
        this.waitForYellow(ticonf);
        return realIndexName;
    }

    public void closeIndex(TargetIndexConfig ticonf, String realIndexName, boolean cleanShutdown) {
        this.checkOpen();
        IndicesAdminClient indicesAdmin = this.client.admin().indices();
        log.info((Object)"Flushing data...");
        indicesAdmin.prepareFlush(new String[]{realIndexName}).get();
        String aliasedIndex = this.getAliasedIndex(ticonf);
        if (cleanShutdown && !realIndexName.equals(aliasedIndex)) {
            log.info((Object)("Redirecting alias '" + ticonf.indexName + "' to new index: " + realIndexName));
            if (!ticonf.aliases.isEmpty()) {
                log.info((Object)("Redirecting additional alias(es) " + String.valueOf(ticonf.aliases.keySet()) + " to new index: " + realIndexName));
            }
            IndicesAliasesRequestBuilder req = indicesAdmin.prepareAliases();
            if (aliasedIndex != null) {
                req.removeAlias(aliasedIndex, ticonf.indexName);
                for (String string : ticonf.aliases.keySet()) {
                    req.removeAlias(aliasedIndex, string);
                }
            }
            req.addAlias(realIndexName, ticonf.indexName);
            for (Map.Entry entry : ticonf.aliases.entrySet()) {
                req.addAlias(realIndexName, (String)entry.getKey(), (String)entry.getValue());
            }
            IndicesAliasesResponse resp = (IndicesAliasesResponse)req.get();
            log.info((Object)("Aliases redirected: " + resp.isAcknowledged()));
            if (aliasedIndex != null) {
                log.info((Object)("Deleting orphaned index: " + aliasedIndex));
                DeleteIndexResponse resp2 = (DeleteIndexResponse)indicesAdmin.prepareDelete(new String[]{aliasedIndex}).get();
                log.info((Object)("Index deleted: " + resp2.isAcknowledged()));
            }
        }
    }

    public void updateAliases(TargetIndexConfig ticonf) {
        IndicesAliasesRequestBuilder req;
        this.waitForYellow(ticonf);
        IndicesAdminClient indicesAdmin = this.client.admin().indices();
        ImmutableOpenMap indexCol = ((GetAliasesResponse)((GetAliasesRequestBuilder)((GetAliasesRequestBuilder)indicesAdmin.prepareGetAliases(new String[]{"*"}).setIndices(new String[]{ticonf.indexName})).setIndicesOptions(IndicesOptions.strictSingleIndexNoExpandForbidClosed())).get()).getAliases();
        Iterator indexes = indexCol.keysIt();
        if (indexes.hasNext()) {
            String aliasedIndex = (String)indexes.next();
            if (indexes.hasNext()) {
                throw new ElasticsearchException("There are more than one index referred by alias='" + ticonf.indexName + "'", new Object[0]);
            }
            List aliases = (List)indexCol.get((Object)aliasedIndex);
            req = indicesAdmin.prepareAliases();
            for (AliasMetaData aliasMetaData : aliases) {
                String alias = aliasMetaData.alias();
                if (ticonf.indexName.equals(alias) || ticonf.aliases.containsKey(alias)) continue;
                log.info((Object)("Removing outdated alias: " + alias));
                req.removeAlias(aliasedIndex, alias);
            }
            for (Map.Entry entry : ticonf.aliases.entrySet()) {
                log.info((Object)("Updating alias: " + (String)entry.getKey()));
                req.addAlias(aliasedIndex, (String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            throw new ElasticsearchException("The alias='" + ticonf.indexName + "' does not exist.", new Object[0]);
        }
        IndicesAliasesResponse resp = (IndicesAliasesResponse)req.get();
        log.info((Object)("Aliases updated: " + resp.isAcknowledged()));
    }

    private Map<Object, Object> mapOf(Object ... items) {
        if (items.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < items.length; i += 2) {
            map.put(items[i], items[i + 1]);
        }
        return map;
    }

    private String getMapping() {
        try {
            LinkedHashMap<String, Map<Object, Object>> props;
            Map mapping;
            if (this.conf.esMapping != null) {
                mapping = XContentHelper.convertToMap((XContent)XContentFactory.xContent((CharSequence)this.conf.esMapping), (String)this.conf.esMapping, (boolean)true);
                if (mapping.containsKey(this.conf.typeName)) {
                    if (mapping.size() != 1) {
                        throw new IllegalArgumentException("If the typeName is part of the mapping, it must be the single root element.");
                    }
                    mapping = (Map)mapping.get(this.conf.typeName);
                }
            } else {
                mapping = new LinkedHashMap();
            }
            if ((props = (LinkedHashMap<String, Map<Object, Object>>)mapping.get("properties")) == null) {
                props = new LinkedHashMap<String, Map<Object, Object>>();
                mapping.put("properties", props);
            }
            if (props.containsKey(this.conf.fieldnameDatestamp) || props.containsKey(this.conf.fieldnameSource) || props.containsKey(this.conf.fieldnameXML)) {
                throw new IllegalArgumentException("The given mapping is not allowed to contain properties for internal field: " + String.valueOf(Arrays.asList(this.conf.fieldnameDatestamp, this.conf.fieldnameSource, this.conf.fieldnameXML)));
            }
            props.put(this.conf.fieldnameDatestamp, this.mapOf("type", "date", "format", "dateOptionalTime", "index", true, "include_in_all", false));
            props.put(this.conf.fieldnameSource, this.mapOf("type", "keyword", "index", true, "include_in_all", false));
            props.put(this.conf.fieldnameXML, this.mapOf("type", "keyword", "index", false, "doc_values", false));
            return XContentFactory.jsonBuilder().map(mapping).string();
        }
        catch (IOException ioe) {
            throw new AssertionError("Cannot happen, because no IO involved.", ioe);
        }
    }

    static {
        try {
            HARVESTER_METADATA_MAPPING = XContentFactory.jsonBuilder().startObject().startObject("_source").field("enabled", true).endObject().startObject("_all").field("enabled", false).endObject().startArray("dynamic_templates").startObject().startObject("kv_pairs").field("match", "*").startObject("mapping").field("type", "keyword").field("index", false).field("store", false).field("doc_values", false).endObject().endObject().endObject().endArray().endObject().string();
        }
        catch (IOException ioe) {
            throw new AssertionError("Cannot happen", ioe);
        }
    }
}

