/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.push;

import de.pangaea.metadataportal.config.Config;
import de.pangaea.metadataportal.config.HarvesterConfig;
import de.pangaea.metadataportal.harvester.Harvester;
import de.pangaea.metadataportal.harvester.SingleFileEntitiesHarvester;
import de.pangaea.metadataportal.processor.DocumentErrorAction;
import de.pangaea.metadataportal.processor.ElasticsearchConnection;
import de.pangaea.metadataportal.processor.MetadataDocument;
import java.time.Instant;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.xml.transform.Source;

public final class PushWrapperHarvester
extends SingleFileEntitiesHarvester {
    private static final ThreadLocal<Consumer<PushWrapperHarvester>> STARTUP_CALLBACK_HOLDER = new ThreadLocal();
    private static final ThreadLocal<Consumer<PushWrapperHarvester>> SHUTDOWN_CALLBACK_HOLDER = new ThreadLocal();
    private static final long TIMEOUT = TimeUnit.SECONDS.toNanos(60L);
    private final Harvester wrappedHarvester;
    private final AtomicLong lastAccessed = new AtomicLong(System.nanoTime());
    private final CountDownLatch latch = new CountDownLatch(1);

    public static boolean isValidHarvesterId(Config conf, String id) {
        return !PushWrapperHarvester.isAllIndexes(id) && conf.harvestersAndIndexes.contains(id) && !conf.targetIndexes.containsKey(id);
    }

    public static PushWrapperHarvester initializeWrapper(Config conf, String id, Consumer<PushWrapperHarvester> shutdownCallback) {
        if (!PushWrapperHarvester.isValidHarvesterId(conf, id)) {
            throw new IllegalArgumentException("Cannot find harvester name: " + id);
        }
        CompletableFuture result = new CompletableFuture();
        new Thread(() -> {
            STARTUP_CALLBACK_HOLDER.set(result::complete);
            SHUTDOWN_CALLBACK_HOLDER.set(shutdownCallback);
            try {
                PushWrapperHarvester.runHarvester(conf, id, PushWrapperHarvester.class);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            finally {
                STARTUP_CALLBACK_HOLDER.remove();
                SHUTDOWN_CALLBACK_HOLDER.remove();
            }
        }, String.format(Locale.ROOT, "PushWrapperHarvester(%s)", id)).start();
        return (PushWrapperHarvester)result.join();
    }

    public PushWrapperHarvester(HarvesterConfig iconfig) throws Exception {
        super(iconfig, DocumentErrorAction.STOP);
        this.wrappedHarvester = iconfig.harvesterClass.getConstructor(HarvesterConfig.class).newInstance(iconfig);
    }

    @Override
    public void prepareReindex(ElasticsearchConnection es, String targetIndex) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void finishReindex(boolean cleanShutdown) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public MetadataDocument createMetadataDocumentInstance() {
        return this.wrappedHarvester.createMetadataDocumentInstance();
    }

    @Override
    protected void enumerateValidHarvesterPropertyNames(Set<String> props) {
        props.addAll(this.wrappedHarvester.getValidHarvesterPropertyNames());
    }

    @Override
    public void open(ElasticsearchConnection es, String targetIndex) throws Exception {
        super.open(es, targetIndex);
        this.cancelMissingDocumentDelete();
    }

    @Override
    public void addDocument(String identifier, Instant lastModified, Source xml) throws Exception {
        this.resetTimer();
        super.addDocument(identifier, lastModified, xml);
    }

    @Override
    public void deleteDocument(String identifier) throws Exception {
        this.resetTimer();
        super.deleteDocument(identifier);
    }

    public void commitAndClose() throws Exception {
        this.latch.countDown();
    }

    private void resetTimer() {
        this.lastAccessed.set(System.nanoTime());
    }

    @Override
    public void harvest() throws Exception {
        this.cancelMissingDocumentDelete();
        this.log.info((Object)"Waiting for push connections...");
        STARTUP_CALLBACK_HOLDER.get().accept(this);
        while (this.latch.getCount() > 0L && System.nanoTime() - this.lastAccessed.get() < TIMEOUT) {
            this.latch.await(1L, TimeUnit.SECONDS);
        }
        SHUTDOWN_CALLBACK_HOLDER.get().accept(this);
        this.log.info((Object)"Shutting down push mode...");
    }
}

