/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class FingerprintTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final char separator;
    private final int maxOutputSize;
    public static ParseField SEPARATOR = new ParseField("separator", new String[0]);
    public static ParseField MAX_OUTPUT_SIZE = new ParseField("max_output_size", new String[0]);
    public static final char DEFAULT_SEPARATOR = ' ';
    public static final int DEFAULT_MAX_OUTPUT_SIZE = 255;

    public FingerprintTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.separator = FingerprintTokenFilterFactory.parseSeparator(settings);
        this.maxOutputSize = settings.getAsInt(MAX_OUTPUT_SIZE.getPreferredName(), 255);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        result = new FingerprintFilter(result, this.maxOutputSize, this.separator);
        return result;
    }

    public static char parseSeparator(Settings settings) throws IllegalArgumentException {
        String customSeparator = settings.get(SEPARATOR.getPreferredName());
        if (customSeparator == null) {
            return ' ';
        }
        if (customSeparator.length() == 1) {
            return customSeparator.charAt(0);
        }
        throw new IllegalArgumentException("Setting [separator] must be a single, non-null character. [" + customSeparator + "] was provided.");
    }
}

