/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;
    private final RemoteClusterService remoteClusterService;
    private final TransportService transportService;

    @Inject
    public TransportFieldCapabilitiesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/field_caps", threadPool, transportService, actionFilters, indexNameExpressionResolver, FieldCapabilitiesRequest::new);
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.transportService = transportService;
        this.shardAction = shardAction;
    }

    @Override
    protected void doExecute(FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexOrAlias((String)idx, clusterState));
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = !remoteClusterIndices.isEmpty() && localIndices.indices().length == 0 ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, localIndices);
        int totalNumRequest = concreteIndices.length + remoteClusterIndices.size();
        CountDown completionCounter = new CountDown(totalNumRequest);
        final List indexResponses = Collections.synchronizedList(new ArrayList());
        final Runnable onResponse = () -> {
            if (completionCounter.countDown()) {
                if (request.isMergeResults()) {
                    listener.onResponse(this.merge(indexResponses));
                } else {
                    listener.onResponse(new FieldCapabilitiesResponse(indexResponses));
                }
            }
        };
        if (totalNumRequest == 0) {
            listener.onResponse(new FieldCapabilitiesResponse());
        } else {
            ActionListener<FieldCapabilitiesIndexResponse> innerListener = new ActionListener<FieldCapabilitiesIndexResponse>(){

                @Override
                public void onResponse(FieldCapabilitiesIndexResponse result) {
                    indexResponses.add(result);
                    onResponse.run();
                }

                @Override
                public void onFailure(Exception e) {
                    onResponse.run();
                }
            };
            for (String index : concreteIndices) {
                this.shardAction.execute(new FieldCapabilitiesIndexRequest(request.fields(), index), innerListener);
            }
            for (Map.Entry entry : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                OriginalIndices originalIndices = (OriginalIndices)entry.getValue();
                this.remoteClusterService.ensureConnected(clusterAlias, ActionListener.wrap(v -> {
                    Transport.Connection connection = this.remoteClusterService.getConnection(clusterAlias);
                    FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
                    remoteRequest.setMergeResults(false);
                    remoteRequest.indicesOptions(originalIndices.indicesOptions());
                    remoteRequest.indices(originalIndices.indices());
                    remoteRequest.fields(request.fields());
                    this.transportService.sendRequest(connection, "indices:data/read/field_caps", (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, new TransportResponseHandler<FieldCapabilitiesResponse>(){

                        @Override
                        public FieldCapabilitiesResponse newInstance() {
                            return new FieldCapabilitiesResponse();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleResponse(FieldCapabilitiesResponse response) {
                            try {
                                for (FieldCapabilitiesIndexResponse res : response.getIndexResponses()) {
                                    indexResponses.add(new FieldCapabilitiesIndexResponse(RemoteClusterAware.buildRemoteIndexName(clusterAlias, res.getIndexName()), res.get()));
                                }
                            }
                            finally {
                                onResponse.run();
                            }
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            onResponse.run();
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }
                    });
                }, e -> onResponse.run()));
            }
        }
    }

    private FieldCapabilitiesResponse merge(List<FieldCapabilitiesIndexResponse> indexResponses) {
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses) {
            this.innerMerge(responseMapBuilder, response.getIndexName(), response.get());
        }
        HashMap<String, Map<String, FieldCapabilities>> responseMap = new HashMap<String, Map<String, FieldCapabilities>>();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            HashMap typeMap = new HashMap();
            boolean multiTypes = ((Map)entry.getValue()).size() > 1;
            for (Map.Entry fieldEntry : ((Map)entry.getValue()).entrySet()) {
                typeMap.put(fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), typeMap);
        }
        return new FieldCapabilitiesResponse(responseMap);
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, String indexName, Map<String, FieldCapabilities> map) {
        for (Map.Entry<String, FieldCapabilities> entry : map.entrySet()) {
            String field = entry.getKey();
            FieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(indexName, fieldCap.isSearchable(), fieldCap.isAggregatable());
        }
    }
}

