/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;

public class PreBuiltTokenFilterFactoryFactory
implements AnalysisModule.AnalysisProvider<TokenFilterFactory> {
    private final TokenFilterFactory tokenFilterFactory;

    public PreBuiltTokenFilterFactoryFactory(TokenFilterFactory tokenFilterFactory) {
        this.tokenFilterFactory = tokenFilterFactory;
    }

    @Override
    public TokenFilterFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        PreBuiltTokenFilters preBuiltTokenFilters;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltTokenFilters = PreBuiltTokenFilters.getOrDefault(name, null)) != null) {
            return preBuiltTokenFilters.getTokenFilterFactory(indexVersion);
        }
        return this.tokenFilterFactory;
    }
}

