/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion2x;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.suggest.Suggest;

public class CompletionSuggestion
extends Suggest.Suggestion<Entry> {
    public static final int TYPE = 2;

    public CompletionSuggestion() {
    }

    public CompletionSuggestion(String name, int size) {
        super(name, size);
    }

    @Override
    public int getWriteableType() {
        return 2;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        protected Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private BytesReference payload;

            public Option(Text text, float score, BytesReference payload) {
                super(text, score);
                this.payload = payload;
            }

            protected Option() {
            }

            public void setPayload(BytesReference payload) {
                this.payload = payload;
            }

            public BytesReference getPayload() {
                return this.payload;
            }

            public String getPayloadAsString() {
                return this.payload.utf8ToString();
            }

            public long getPayloadAsLong() {
                return Long.parseLong(this.payload.utf8ToString());
            }

            public double getPayloadAsDouble() {
                return Double.parseDouble(this.payload.utf8ToString());
            }

            public Map<String, Object> getPayloadAsMap() {
                return XContentHelper.convertToMap(this.payload, false).v2();
            }

            @Override
            public void setScore(float score) {
                super.setScore(score);
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                super.innerToXContent(builder, params);
                if (this.payload != null && this.payload.length() > 0) {
                    XContentType contentType = XContentFactory.xContentType(this.payload);
                    if (contentType == null) {
                        builder.field("payload", this.payload.utf8ToString());
                    } else {
                        builder.rawField("payload", this.payload);
                    }
                }
                return builder;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                this.payload = in.readBytesReference();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeBytesReference(this.payload);
            }
        }
    }
}

