/*
 * Decompiled with CFR 0.152.
 */
package de.pangaea.metadataportal.processor;

import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;

public class MinimalTransportClient
extends TransportClient {
    private static final Collection<Class<? extends Plugin>> PRE_INSTALLED_PLUGINS;

    private static void initializeNetty() {
        MinimalTransportClient.setSystemPropertyIfUnset("io.netty.noUnsafe", Boolean.toString(true));
        MinimalTransportClient.setSystemPropertyIfUnset("io.netty.noKeySetOptimization", Boolean.toString(true));
        MinimalTransportClient.setSystemPropertyIfUnset("io.netty.recycler.maxCapacityPerThread", Integer.toString(0));
    }

    private static void setSystemPropertyIfUnset(String key, String value) {
        String currentValue = System.getProperty(key);
        if (currentValue == null) {
            System.setProperty(key, value);
        }
    }

    @SafeVarargs
    public MinimalTransportClient(Settings settings, Class<? extends Plugin> ... plugins) {
        this(settings, Arrays.asList(plugins));
    }

    public MinimalTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(settings, plugins, null);
    }

    public MinimalTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins, TransportClient.HostFailureListener hostFailureListener) {
        super(settings, Settings.EMPTY, MinimalTransportClient.addPlugins(plugins, PRE_INSTALLED_PLUGINS), hostFailureListener);
    }

    public void close() {
        super.close();
        if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || ((String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings)).equals("netty4")) {
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        MinimalTransportClient.initializeNetty();
        PRE_INSTALLED_PLUGINS = Arrays.asList(Netty4Plugin.class, ReindexPlugin.class);
    }
}

