/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;

public abstract class AliasAction {
    private final String index;

    private AliasAction(String index) {
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("[index] is required");
        }
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    abstract boolean removeIndex();

    abstract boolean apply(NewAliasValidator var1, MetaData.Builder var2, IndexMetaData var3);

    public static class RemoveIndex
    extends AliasAction {
        public RemoveIndex(String index) {
            super(index);
        }

        @Override
        boolean removeIndex() {
            return true;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, MetaData.Builder metadata, IndexMetaData index) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Remove
    extends AliasAction {
        private final String alias;

        public Remove(String index, String alias) {
            super(index);
            if (!Strings.hasText(alias)) {
                throw new IllegalArgumentException("[alias] is required");
            }
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        boolean removeIndex() {
            return false;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, MetaData.Builder metadata, IndexMetaData index) {
            if (!index.getAliases().containsKey(this.alias)) {
                return false;
            }
            metadata.put(IndexMetaData.builder(index).removeAlias(this.alias));
            return true;
        }
    }

    public static class Add
    extends AliasAction {
        private final String alias;
        @Nullable
        private final String filter;
        @Nullable
        private final String indexRouting;
        @Nullable
        private final String searchRouting;

        public Add(String index, String alias, @Nullable String filter, @Nullable String indexRouting, @Nullable String searchRouting) {
            super(index);
            if (!Strings.hasText(alias)) {
                throw new IllegalArgumentException("[alias] is required");
            }
            this.alias = alias;
            this.filter = filter;
            this.indexRouting = indexRouting;
            this.searchRouting = searchRouting;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        boolean removeIndex() {
            return false;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, MetaData.Builder metadata, IndexMetaData index) {
            aliasValidator.validate(this.alias, this.indexRouting, this.filter);
            AliasMetaData newAliasMd = AliasMetaData.newAliasMetaDataBuilder(this.alias).filter(this.filter).indexRouting(this.indexRouting).searchRouting(this.searchRouting).build();
            AliasMetaData currentAliasMd = index.getAliases().get(this.alias);
            if (currentAliasMd != null && currentAliasMd.equals(newAliasMd)) {
                return false;
            }
            metadata.put(IndexMetaData.builder(index).putAlias(newAliasMd));
            return true;
        }
    }

    @FunctionalInterface
    public static interface NewAliasValidator {
        public void validate(String var1, @Nullable String var2, @Nullable String var3);
    }
}

